# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FeatureGroupArgs', 'FeatureGroup']

@pulumi.input_type
class FeatureGroupArgs:
    def __init__(__self__, *,
                 event_time_feature_name: pulumi.Input[str],
                 feature_definitions: pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]],
                 record_identifier_feature_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']] = None,
                 online_store_config: Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureGroupTagArgs']]]] = None):
        """
        The set of arguments for constructing a FeatureGroup resource.
        :param pulumi.Input[str] event_time_feature_name: The Event Time Feature Name.
        :param pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]] feature_definitions: An Array of Feature Definition
        :param pulumi.Input[str] record_identifier_feature_name: The Record Identifier Feature Name.
        :param pulumi.Input[str] description: Description about the FeatureGroup.
        :param pulumi.Input[str] feature_group_name: The Name of the FeatureGroup.
        :param pulumi.Input[str] role_arn: Role Arn
        :param pulumi.Input[Sequence[pulumi.Input['FeatureGroupTagArgs']]] tags: An array of key-value pair to apply to this resource.
        """
        pulumi.set(__self__, "event_time_feature_name", event_time_feature_name)
        pulumi.set(__self__, "feature_definitions", feature_definitions)
        pulumi.set(__self__, "record_identifier_feature_name", record_identifier_feature_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_group_name is not None:
            pulumi.set(__self__, "feature_group_name", feature_group_name)
        if offline_store_config is not None:
            pulumi.set(__self__, "offline_store_config", offline_store_config)
        if online_store_config is not None:
            pulumi.set(__self__, "online_store_config", online_store_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="eventTimeFeatureName")
    def event_time_feature_name(self) -> pulumi.Input[str]:
        """
        The Event Time Feature Name.
        """
        return pulumi.get(self, "event_time_feature_name")

    @event_time_feature_name.setter
    def event_time_feature_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_time_feature_name", value)

    @property
    @pulumi.getter(name="featureDefinitions")
    def feature_definitions(self) -> pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]]:
        """
        An Array of Feature Definition
        """
        return pulumi.get(self, "feature_definitions")

    @feature_definitions.setter
    def feature_definitions(self, value: pulumi.Input[Sequence[pulumi.Input['FeatureGroupFeatureDefinitionArgs']]]):
        pulumi.set(self, "feature_definitions", value)

    @property
    @pulumi.getter(name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> pulumi.Input[str]:
        """
        The Record Identifier Feature Name.
        """
        return pulumi.get(self, "record_identifier_feature_name")

    @record_identifier_feature_name.setter
    def record_identifier_feature_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "record_identifier_feature_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description about the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureGroupName")
    def feature_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the FeatureGroup.
        """
        return pulumi.get(self, "feature_group_name")

    @feature_group_name.setter
    def feature_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_group_name", value)

    @property
    @pulumi.getter(name="offlineStoreConfig")
    def offline_store_config(self) -> Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']]:
        return pulumi.get(self, "offline_store_config")

    @offline_store_config.setter
    def offline_store_config(self, value: Optional[pulumi.Input['OfflineStoreConfigPropertiesArgs']]):
        pulumi.set(self, "offline_store_config", value)

    @property
    @pulumi.getter(name="onlineStoreConfig")
    def online_store_config(self) -> Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']]:
        return pulumi.get(self, "online_store_config")

    @online_store_config.setter
    def online_store_config(self, value: Optional[pulumi.Input['OnlineStoreConfigPropertiesArgs']]):
        pulumi.set(self, "online_store_config", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role Arn
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FeatureGroupTagArgs']]]]:
        """
        An array of key-value pair to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FeatureGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)


class FeatureGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_time_feature_name: Optional[pulumi.Input[str]] = None,
                 feature_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupFeatureDefinitionArgs']]]]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input[pulumi.InputType['OfflineStoreConfigPropertiesArgs']]] = None,
                 online_store_config: Optional[pulumi.Input[pulumi.InputType['OnlineStoreConfigPropertiesArgs']]] = None,
                 record_identifier_feature_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::FeatureGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description about the FeatureGroup.
        :param pulumi.Input[str] event_time_feature_name: The Event Time Feature Name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupFeatureDefinitionArgs']]]] feature_definitions: An Array of Feature Definition
        :param pulumi.Input[str] feature_group_name: The Name of the FeatureGroup.
        :param pulumi.Input[str] record_identifier_feature_name: The Record Identifier Feature Name.
        :param pulumi.Input[str] role_arn: Role Arn
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupTagArgs']]]] tags: An array of key-value pair to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FeatureGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::FeatureGroup

        :param str resource_name: The name of the resource.
        :param FeatureGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FeatureGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_time_feature_name: Optional[pulumi.Input[str]] = None,
                 feature_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupFeatureDefinitionArgs']]]]] = None,
                 feature_group_name: Optional[pulumi.Input[str]] = None,
                 offline_store_config: Optional[pulumi.Input[pulumi.InputType['OfflineStoreConfigPropertiesArgs']]] = None,
                 online_store_config: Optional[pulumi.Input[pulumi.InputType['OnlineStoreConfigPropertiesArgs']]] = None,
                 record_identifier_feature_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FeatureGroupTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FeatureGroupArgs.__new__(FeatureGroupArgs)

            __props__.__dict__["description"] = description
            if event_time_feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'event_time_feature_name'")
            __props__.__dict__["event_time_feature_name"] = event_time_feature_name
            if feature_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'feature_definitions'")
            __props__.__dict__["feature_definitions"] = feature_definitions
            __props__.__dict__["feature_group_name"] = feature_group_name
            __props__.__dict__["offline_store_config"] = offline_store_config
            __props__.__dict__["online_store_config"] = online_store_config
            if record_identifier_feature_name is None and not opts.urn:
                raise TypeError("Missing required property 'record_identifier_feature_name'")
            __props__.__dict__["record_identifier_feature_name"] = record_identifier_feature_name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
        super(FeatureGroup, __self__).__init__(
            'aws-native:sagemaker:FeatureGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FeatureGroup':
        """
        Get an existing FeatureGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FeatureGroupArgs.__new__(FeatureGroupArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["event_time_feature_name"] = None
        __props__.__dict__["feature_definitions"] = None
        __props__.__dict__["feature_group_name"] = None
        __props__.__dict__["offline_store_config"] = None
        __props__.__dict__["online_store_config"] = None
        __props__.__dict__["record_identifier_feature_name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        return FeatureGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description about the FeatureGroup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventTimeFeatureName")
    def event_time_feature_name(self) -> pulumi.Output[str]:
        """
        The Event Time Feature Name.
        """
        return pulumi.get(self, "event_time_feature_name")

    @property
    @pulumi.getter(name="featureDefinitions")
    def feature_definitions(self) -> pulumi.Output[Sequence['outputs.FeatureGroupFeatureDefinition']]:
        """
        An Array of Feature Definition
        """
        return pulumi.get(self, "feature_definitions")

    @property
    @pulumi.getter(name="featureGroupName")
    def feature_group_name(self) -> pulumi.Output[str]:
        """
        The Name of the FeatureGroup.
        """
        return pulumi.get(self, "feature_group_name")

    @property
    @pulumi.getter(name="offlineStoreConfig")
    def offline_store_config(self) -> pulumi.Output[Optional['outputs.OfflineStoreConfigProperties']]:
        return pulumi.get(self, "offline_store_config")

    @property
    @pulumi.getter(name="onlineStoreConfig")
    def online_store_config(self) -> pulumi.Output[Optional['outputs.OnlineStoreConfigProperties']]:
        return pulumi.get(self, "online_store_config")

    @property
    @pulumi.getter(name="recordIdentifierFeatureName")
    def record_identifier_feature_name(self) -> pulumi.Output[str]:
        """
        The Record Identifier Feature Name.
        """
        return pulumi.get(self, "record_identifier_feature_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Role Arn
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.FeatureGroupTag']]]:
        """
        An array of key-value pair to apply to this resource.
        """
        return pulumi.get(self, "tags")

