# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeviceInitArgs', 'Device']

@pulumi.input_type
class DeviceInitArgs:
    def __init__(__self__, *,
                 device_fleet_name: pulumi.Input[str],
                 device: Optional[pulumi.Input['DeviceArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTagArgs']]]] = None):
        """
        The set of arguments for constructing a Device resource.
        :param pulumi.Input[str] device_fleet_name: The name of the edge device fleet
        :param pulumi.Input['DeviceArgs'] device: The Edge Device you want to register against a device fleet
        :param pulumi.Input[Sequence[pulumi.Input['DeviceTagArgs']]] tags: Associate tags with the resource
        """
        pulumi.set(__self__, "device_fleet_name", device_fleet_name)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deviceFleetName")
    def device_fleet_name(self) -> pulumi.Input[str]:
        """
        The name of the edge device fleet
        """
        return pulumi.get(self, "device_fleet_name")

    @device_fleet_name.setter
    def device_fleet_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_fleet_name", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input['DeviceArgs']]:
        """
        The Edge Device you want to register against a device fleet
        """
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input['DeviceArgs']]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTagArgs']]]]:
        """
        Associate tags with the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Device(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[pulumi.InputType['DeviceArgs']]] = None,
                 device_fleet_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::SageMaker::Device

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DeviceArgs']] device: The Edge Device you want to register against a device fleet
        :param pulumi.Input[str] device_fleet_name: The name of the edge device fleet
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceTagArgs']]]] tags: Associate tags with the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeviceInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::SageMaker::Device

        :param str resource_name: The name of the resource.
        :param DeviceInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeviceInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 device: Optional[pulumi.Input[pulumi.InputType['DeviceArgs']]] = None,
                 device_fleet_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DeviceTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeviceInitArgs.__new__(DeviceInitArgs)

            __props__.__dict__["device"] = device
            if device_fleet_name is None and not opts.urn:
                raise TypeError("Missing required property 'device_fleet_name'")
            __props__.__dict__["device_fleet_name"] = device_fleet_name
            __props__.__dict__["tags"] = tags
        super(Device, __self__).__init__(
            'aws-native:sagemaker:Device',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Device':
        """
        Get an existing Device resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeviceInitArgs.__new__(DeviceInitArgs)

        __props__.__dict__["device"] = None
        __props__.__dict__["device_fleet_name"] = None
        __props__.__dict__["tags"] = None
        return Device(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def device(self) -> pulumi.Output[Optional['outputs.Device']]:
        """
        The Edge Device you want to register against a device fleet
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="deviceFleetName")
    def device_fleet_name(self) -> pulumi.Output[str]:
        """
        The name of the edge device fleet
        """
        return pulumi.get(self, "device_fleet_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DeviceTag']]]:
        """
        Associate tags with the resource
        """
        return pulumi.get(self, "tags")

