# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    def __init__(__self__, app_arn=None, app_assessment_schedule=None, app_template_body=None, description=None, resiliency_policy_arn=None, resource_mappings=None, tags=None):
        if app_arn and not isinstance(app_arn, str):
            raise TypeError("Expected argument 'app_arn' to be a str")
        pulumi.set(__self__, "app_arn", app_arn)
        if app_assessment_schedule and not isinstance(app_assessment_schedule, str):
            raise TypeError("Expected argument 'app_assessment_schedule' to be a str")
        pulumi.set(__self__, "app_assessment_schedule", app_assessment_schedule)
        if app_template_body and not isinstance(app_template_body, str):
            raise TypeError("Expected argument 'app_template_body' to be a str")
        pulumi.set(__self__, "app_template_body", app_template_body)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if resiliency_policy_arn and not isinstance(resiliency_policy_arn, str):
            raise TypeError("Expected argument 'resiliency_policy_arn' to be a str")
        pulumi.set(__self__, "resiliency_policy_arn", resiliency_policy_arn)
        if resource_mappings and not isinstance(resource_mappings, list):
            raise TypeError("Expected argument 'resource_mappings' to be a list")
        pulumi.set(__self__, "resource_mappings", resource_mappings)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appArn")
    def app_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the App.
        """
        return pulumi.get(self, "app_arn")

    @property
    @pulumi.getter(name="appAssessmentSchedule")
    def app_assessment_schedule(self) -> Optional['AppAssessmentSchedule']:
        """
        Assessment execution schedule.
        """
        return pulumi.get(self, "app_assessment_schedule")

    @property
    @pulumi.getter(name="appTemplateBody")
    def app_template_body(self) -> Optional[str]:
        """
        A string containing full ResilienceHub app template body.
        """
        return pulumi.get(self, "app_template_body")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        App description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resiliencyPolicyArn")
    def resiliency_policy_arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the Resiliency Policy.
        """
        return pulumi.get(self, "resiliency_policy_arn")

    @property
    @pulumi.getter(name="resourceMappings")
    def resource_mappings(self) -> Optional[Sequence['outputs.AppResourceMapping']]:
        """
        An array of ResourceMapping objects.
        """
        return pulumi.get(self, "resource_mappings")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.AppTagMap']:
        return pulumi.get(self, "tags")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            app_arn=self.app_arn,
            app_assessment_schedule=self.app_assessment_schedule,
            app_template_body=self.app_template_body,
            description=self.description,
            resiliency_policy_arn=self.resiliency_policy_arn,
            resource_mappings=self.resource_mappings,
            tags=self.tags)


def get_app(app_arn: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Resource Type Definition for AWS::ResilienceHub::App.


    :param str app_arn: Amazon Resource Name (ARN) of the App.
    """
    __args__ = dict()
    __args__['appArn'] = app_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:resiliencehub:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        app_arn=__ret__.app_arn,
        app_assessment_schedule=__ret__.app_assessment_schedule,
        app_template_body=__ret__.app_template_body,
        description=__ret__.description,
        resiliency_policy_arn=__ret__.resiliency_policy_arn,
        resource_mappings=__ret__.resource_mappings,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_app)
def get_app_output(app_arn: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppResult]:
    """
    Resource Type Definition for AWS::ResilienceHub::App.


    :param str app_arn: Amazon Resource Name (ARN) of the App.
    """
    ...
