# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAssetModelResult',
    'AwaitableGetAssetModelResult',
    'get_asset_model',
    'get_asset_model_output',
]

@pulumi.output_type
class GetAssetModelResult:
    def __init__(__self__, asset_model_arn=None, asset_model_composite_models=None, asset_model_description=None, asset_model_hierarchies=None, asset_model_id=None, asset_model_name=None, asset_model_properties=None, tags=None):
        if asset_model_arn and not isinstance(asset_model_arn, str):
            raise TypeError("Expected argument 'asset_model_arn' to be a str")
        pulumi.set(__self__, "asset_model_arn", asset_model_arn)
        if asset_model_composite_models and not isinstance(asset_model_composite_models, list):
            raise TypeError("Expected argument 'asset_model_composite_models' to be a list")
        pulumi.set(__self__, "asset_model_composite_models", asset_model_composite_models)
        if asset_model_description and not isinstance(asset_model_description, str):
            raise TypeError("Expected argument 'asset_model_description' to be a str")
        pulumi.set(__self__, "asset_model_description", asset_model_description)
        if asset_model_hierarchies and not isinstance(asset_model_hierarchies, list):
            raise TypeError("Expected argument 'asset_model_hierarchies' to be a list")
        pulumi.set(__self__, "asset_model_hierarchies", asset_model_hierarchies)
        if asset_model_id and not isinstance(asset_model_id, str):
            raise TypeError("Expected argument 'asset_model_id' to be a str")
        pulumi.set(__self__, "asset_model_id", asset_model_id)
        if asset_model_name and not isinstance(asset_model_name, str):
            raise TypeError("Expected argument 'asset_model_name' to be a str")
        pulumi.set(__self__, "asset_model_name", asset_model_name)
        if asset_model_properties and not isinstance(asset_model_properties, list):
            raise TypeError("Expected argument 'asset_model_properties' to be a list")
        pulumi.set(__self__, "asset_model_properties", asset_model_properties)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assetModelArn")
    def asset_model_arn(self) -> Optional[str]:
        """
        The ARN of the asset model, which has the following format.
        """
        return pulumi.get(self, "asset_model_arn")

    @property
    @pulumi.getter(name="assetModelCompositeModels")
    def asset_model_composite_models(self) -> Optional[Sequence['outputs.AssetModelCompositeModel']]:
        """
        The composite asset models that are part of this asset model. Composite asset models are asset models that contain specific properties.
        """
        return pulumi.get(self, "asset_model_composite_models")

    @property
    @pulumi.getter(name="assetModelDescription")
    def asset_model_description(self) -> Optional[str]:
        """
        A description for the asset model.
        """
        return pulumi.get(self, "asset_model_description")

    @property
    @pulumi.getter(name="assetModelHierarchies")
    def asset_model_hierarchies(self) -> Optional[Sequence['outputs.AssetModelHierarchy']]:
        """
        The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. You can specify up to 10 hierarchies per asset model.
        """
        return pulumi.get(self, "asset_model_hierarchies")

    @property
    @pulumi.getter(name="assetModelId")
    def asset_model_id(self) -> Optional[str]:
        """
        The ID of the asset model.
        """
        return pulumi.get(self, "asset_model_id")

    @property
    @pulumi.getter(name="assetModelName")
    def asset_model_name(self) -> Optional[str]:
        """
        A unique, friendly name for the asset model.
        """
        return pulumi.get(self, "asset_model_name")

    @property
    @pulumi.getter(name="assetModelProperties")
    def asset_model_properties(self) -> Optional[Sequence['outputs.AssetModelProperty']]:
        """
        The property definitions of the asset model. You can specify up to 200 properties per asset model.
        """
        return pulumi.get(self, "asset_model_properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AssetModelTag']]:
        """
        A list of key-value pairs that contain metadata for the asset model.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAssetModelResult(GetAssetModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetModelResult(
            asset_model_arn=self.asset_model_arn,
            asset_model_composite_models=self.asset_model_composite_models,
            asset_model_description=self.asset_model_description,
            asset_model_hierarchies=self.asset_model_hierarchies,
            asset_model_id=self.asset_model_id,
            asset_model_name=self.asset_model_name,
            asset_model_properties=self.asset_model_properties,
            tags=self.tags)


def get_asset_model(asset_model_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetModelResult:
    """
    Resource schema for AWS::IoTSiteWise::AssetModel


    :param str asset_model_id: The ID of the asset model.
    """
    __args__ = dict()
    __args__['assetModelId'] = asset_model_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:iotsitewise:getAssetModel', __args__, opts=opts, typ=GetAssetModelResult).value

    return AwaitableGetAssetModelResult(
        asset_model_arn=__ret__.asset_model_arn,
        asset_model_composite_models=__ret__.asset_model_composite_models,
        asset_model_description=__ret__.asset_model_description,
        asset_model_hierarchies=__ret__.asset_model_hierarchies,
        asset_model_id=__ret__.asset_model_id,
        asset_model_name=__ret__.asset_model_name,
        asset_model_properties=__ret__.asset_model_properties,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_asset_model)
def get_asset_model_output(asset_model_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssetModelResult]:
    """
    Resource schema for AWS::IoTSiteWise::AssetModel


    :param str asset_model_id: The ID of the asset model.
    """
    ...
