# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetEndpointGroupResult',
    'AwaitableGetEndpointGroupResult',
    'get_endpoint_group',
    'get_endpoint_group_output',
]

@pulumi.output_type
class GetEndpointGroupResult:
    def __init__(__self__, endpoint_configurations=None, endpoint_group_arn=None, health_check_interval_seconds=None, health_check_path=None, health_check_port=None, health_check_protocol=None, port_overrides=None, threshold_count=None, traffic_dial_percentage=None):
        if endpoint_configurations and not isinstance(endpoint_configurations, list):
            raise TypeError("Expected argument 'endpoint_configurations' to be a list")
        pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        if endpoint_group_arn and not isinstance(endpoint_group_arn, str):
            raise TypeError("Expected argument 'endpoint_group_arn' to be a str")
        pulumi.set(__self__, "endpoint_group_arn", endpoint_group_arn)
        if health_check_interval_seconds and not isinstance(health_check_interval_seconds, int):
            raise TypeError("Expected argument 'health_check_interval_seconds' to be a int")
        pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_path and not isinstance(health_check_path, str):
            raise TypeError("Expected argument 'health_check_path' to be a str")
        pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_port and not isinstance(health_check_port, int):
            raise TypeError("Expected argument 'health_check_port' to be a int")
        pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol and not isinstance(health_check_protocol, str):
            raise TypeError("Expected argument 'health_check_protocol' to be a str")
        pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if port_overrides and not isinstance(port_overrides, list):
            raise TypeError("Expected argument 'port_overrides' to be a list")
        pulumi.set(__self__, "port_overrides", port_overrides)
        if threshold_count and not isinstance(threshold_count, int):
            raise TypeError("Expected argument 'threshold_count' to be a int")
        pulumi.set(__self__, "threshold_count", threshold_count)
        if traffic_dial_percentage and not isinstance(traffic_dial_percentage, float):
            raise TypeError("Expected argument 'traffic_dial_percentage' to be a float")
        pulumi.set(__self__, "traffic_dial_percentage", traffic_dial_percentage)

    @property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Optional[Sequence['outputs.EndpointGroupEndpointConfiguration']]:
        """
        The list of endpoint objects.
        """
        return pulumi.get(self, "endpoint_configurations")

    @property
    @pulumi.getter(name="endpointGroupArn")
    def endpoint_group_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the endpoint group
        """
        return pulumi.get(self, "endpoint_group_arn")

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[int]:
        """
        The time in seconds between each health check for an endpoint. Must be a value of 10 or 30
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[str]:
        return pulumi.get(self, "health_check_path")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[int]:
        """
        The port that AWS Global Accelerator uses to check the health of endpoints in this endpoint group.
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional['EndpointGroupHealthCheckProtocol']:
        """
        The protocol that AWS Global Accelerator uses to check the health of endpoints in this endpoint group.
        """
        return pulumi.get(self, "health_check_protocol")

    @property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Optional[Sequence['outputs.EndpointGroupPortOverride']]:
        return pulumi.get(self, "port_overrides")

    @property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> Optional[int]:
        """
        The number of consecutive health checks required to set the state of the endpoint to unhealthy.
        """
        return pulumi.get(self, "threshold_count")

    @property
    @pulumi.getter(name="trafficDialPercentage")
    def traffic_dial_percentage(self) -> Optional[float]:
        """
        The percentage of traffic to sent to an AWS Region
        """
        return pulumi.get(self, "traffic_dial_percentage")


class AwaitableGetEndpointGroupResult(GetEndpointGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointGroupResult(
            endpoint_configurations=self.endpoint_configurations,
            endpoint_group_arn=self.endpoint_group_arn,
            health_check_interval_seconds=self.health_check_interval_seconds,
            health_check_path=self.health_check_path,
            health_check_port=self.health_check_port,
            health_check_protocol=self.health_check_protocol,
            port_overrides=self.port_overrides,
            threshold_count=self.threshold_count,
            traffic_dial_percentage=self.traffic_dial_percentage)


def get_endpoint_group(endpoint_group_arn: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointGroupResult:
    """
    Resource Type definition for AWS::GlobalAccelerator::EndpointGroup


    :param str endpoint_group_arn: The Amazon Resource Name (ARN) of the endpoint group
    """
    __args__ = dict()
    __args__['endpointGroupArn'] = endpoint_group_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:globalaccelerator:getEndpointGroup', __args__, opts=opts, typ=GetEndpointGroupResult).value

    return AwaitableGetEndpointGroupResult(
        endpoint_configurations=__ret__.endpoint_configurations,
        endpoint_group_arn=__ret__.endpoint_group_arn,
        health_check_interval_seconds=__ret__.health_check_interval_seconds,
        health_check_path=__ret__.health_check_path,
        health_check_port=__ret__.health_check_port,
        health_check_protocol=__ret__.health_check_protocol,
        port_overrides=__ret__.port_overrides,
        threshold_count=__ret__.threshold_count,
        traffic_dial_percentage=__ret__.traffic_dial_percentage)


@_utilities.lift_output_func(get_endpoint_group)
def get_endpoint_group_output(endpoint_group_arn: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEndpointGroupResult]:
    """
    Resource Type definition for AWS::GlobalAccelerator::EndpointGroup


    :param str endpoint_group_arn: The Amazon Resource Name (ARN) of the endpoint group
    """
    ...
