# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'GetApiDestinationResult',
    'AwaitableGetApiDestinationResult',
    'get_api_destination',
    'get_api_destination_output',
]

@pulumi.output_type
class GetApiDestinationResult:
    def __init__(__self__, arn=None, connection_arn=None, description=None, http_method=None, invocation_endpoint=None, invocation_rate_limit_per_second=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if connection_arn and not isinstance(connection_arn, str):
            raise TypeError("Expected argument 'connection_arn' to be a str")
        pulumi.set(__self__, "connection_arn", connection_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if http_method and not isinstance(http_method, str):
            raise TypeError("Expected argument 'http_method' to be a str")
        pulumi.set(__self__, "http_method", http_method)
        if invocation_endpoint and not isinstance(invocation_endpoint, str):
            raise TypeError("Expected argument 'invocation_endpoint' to be a str")
        pulumi.set(__self__, "invocation_endpoint", invocation_endpoint)
        if invocation_rate_limit_per_second and not isinstance(invocation_rate_limit_per_second, int):
            raise TypeError("Expected argument 'invocation_rate_limit_per_second' to be a int")
        pulumi.set(__self__, "invocation_rate_limit_per_second", invocation_rate_limit_per_second)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The arn of the api destination.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="connectionArn")
    def connection_arn(self) -> Optional[str]:
        """
        The arn of the connection.
        """
        return pulumi.get(self, "connection_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional['ApiDestinationHttpMethod']:
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="invocationEndpoint")
    def invocation_endpoint(self) -> Optional[str]:
        """
        Url endpoint to invoke.
        """
        return pulumi.get(self, "invocation_endpoint")

    @property
    @pulumi.getter(name="invocationRateLimitPerSecond")
    def invocation_rate_limit_per_second(self) -> Optional[int]:
        return pulumi.get(self, "invocation_rate_limit_per_second")


class AwaitableGetApiDestinationResult(GetApiDestinationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiDestinationResult(
            arn=self.arn,
            connection_arn=self.connection_arn,
            description=self.description,
            http_method=self.http_method,
            invocation_endpoint=self.invocation_endpoint,
            invocation_rate_limit_per_second=self.invocation_rate_limit_per_second)


def get_api_destination(name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiDestinationResult:
    """
    Resource Type definition for AWS::Events::ApiDestination.


    :param str name: Name of the apiDestination.
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:events:getApiDestination', __args__, opts=opts, typ=GetApiDestinationResult).value

    return AwaitableGetApiDestinationResult(
        arn=__ret__.arn,
        connection_arn=__ret__.connection_arn,
        description=__ret__.description,
        http_method=__ret__.http_method,
        invocation_endpoint=__ret__.invocation_endpoint,
        invocation_rate_limit_per_second=__ret__.invocation_rate_limit_per_second)


@_utilities.lift_output_func(get_api_destination)
def get_api_destination_output(name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApiDestinationResult]:
    """
    Resource Type definition for AWS::Events::ApiDestination.


    :param str name: Name of the apiDestination.
    """
    ...
