# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFileSystemResult',
    'AwaitableGetFileSystemResult',
    'get_file_system',
    'get_file_system_output',
]

@pulumi.output_type
class GetFileSystemResult:
    def __init__(__self__, arn=None, backup_policy=None, file_system_id=None, file_system_policy=None, file_system_tags=None, lifecycle_policies=None, provisioned_throughput_in_mibps=None, throughput_mode=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if backup_policy and not isinstance(backup_policy, dict):
            raise TypeError("Expected argument 'backup_policy' to be a dict")
        pulumi.set(__self__, "backup_policy", backup_policy)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_policy and not isinstance(file_system_policy, dict):
            raise TypeError("Expected argument 'file_system_policy' to be a dict")
        pulumi.set(__self__, "file_system_policy", file_system_policy)
        if file_system_tags and not isinstance(file_system_tags, list):
            raise TypeError("Expected argument 'file_system_tags' to be a list")
        pulumi.set(__self__, "file_system_tags", file_system_tags)
        if lifecycle_policies and not isinstance(lifecycle_policies, list):
            raise TypeError("Expected argument 'lifecycle_policies' to be a list")
        pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if provisioned_throughput_in_mibps and not isinstance(provisioned_throughput_in_mibps, float):
            raise TypeError("Expected argument 'provisioned_throughput_in_mibps' to be a float")
        pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if throughput_mode and not isinstance(throughput_mode, str):
            raise TypeError("Expected argument 'throughput_mode' to be a str")
        pulumi.set(__self__, "throughput_mode", throughput_mode)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional['outputs.FileSystemBackupPolicy']:
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPolicy")
    def file_system_policy(self) -> Optional[Any]:
        return pulumi.get(self, "file_system_policy")

    @property
    @pulumi.getter(name="fileSystemTags")
    def file_system_tags(self) -> Optional[Sequence['outputs.FileSystemElasticFileSystemTag']]:
        return pulumi.get(self, "file_system_tags")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[Sequence['outputs.FileSystemLifecyclePolicy']]:
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[float]:
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[str]:
        return pulumi.get(self, "throughput_mode")


class AwaitableGetFileSystemResult(GetFileSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileSystemResult(
            arn=self.arn,
            backup_policy=self.backup_policy,
            file_system_id=self.file_system_id,
            file_system_policy=self.file_system_policy,
            file_system_tags=self.file_system_tags,
            lifecycle_policies=self.lifecycle_policies,
            provisioned_throughput_in_mibps=self.provisioned_throughput_in_mibps,
            throughput_mode=self.throughput_mode)


def get_file_system(file_system_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileSystemResult:
    """
    Resource Type definition for AWS::EFS::FileSystem
    """
    __args__ = dict()
    __args__['fileSystemId'] = file_system_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:efs:getFileSystem', __args__, opts=opts, typ=GetFileSystemResult).value

    return AwaitableGetFileSystemResult(
        arn=__ret__.arn,
        backup_policy=__ret__.backup_policy,
        file_system_id=__ret__.file_system_id,
        file_system_policy=__ret__.file_system_policy,
        file_system_tags=__ret__.file_system_tags,
        lifecycle_policies=__ret__.lifecycle_policies,
        provisioned_throughput_in_mibps=__ret__.provisioned_throughput_in_mibps,
        throughput_mode=__ret__.throughput_mode)


@_utilities.lift_output_func(get_file_system)
def get_file_system_output(file_system_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFileSystemResult]:
    """
    Resource Type definition for AWS::EFS::FileSystem
    """
    ...
