# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PrimaryTaskSetArgs', 'PrimaryTaskSet']

@pulumi.input_type
class PrimaryTaskSetArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 service: pulumi.Input[str],
                 task_set_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a PrimaryTaskSet resource.
        :param pulumi.Input[str] cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        :param pulumi.Input[str] task_set_id: The ID or full Amazon Resource Name (ARN) of the task set.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "task_set_id", task_set_id)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="taskSetId")
    def task_set_id(self) -> pulumi.Input[str]:
        """
        The ID or full Amazon Resource Name (ARN) of the task set.
        """
        return pulumi.get(self, "task_set_id")

    @task_set_id.setter
    def task_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_set_id", value)


class PrimaryTaskSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 task_set_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A pseudo-resource that manages which of your ECS task sets is primary.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[str] service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        :param pulumi.Input[str] task_set_id: The ID or full Amazon Resource Name (ARN) of the task set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrimaryTaskSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A pseudo-resource that manages which of your ECS task sets is primary.

        :param str resource_name: The name of the resource.
        :param PrimaryTaskSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrimaryTaskSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 task_set_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrimaryTaskSetArgs.__new__(PrimaryTaskSetArgs)

            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if task_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'task_set_id'")
            __props__.__dict__["task_set_id"] = task_set_id
        super(PrimaryTaskSet, __self__).__init__(
            'aws-native:ecs:PrimaryTaskSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PrimaryTaskSet':
        """
        Get an existing PrimaryTaskSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PrimaryTaskSetArgs.__new__(PrimaryTaskSetArgs)

        __props__.__dict__["cluster"] = None
        __props__.__dict__["service"] = None
        __props__.__dict__["task_set_id"] = None
        return PrimaryTaskSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[str]:
        """
        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="taskSetId")
    def task_set_id(self) -> pulumi.Output[str]:
        """
        The ID or full Amazon Resource Name (ARN) of the task set.
        """
        return pulumi.get(self, "task_set_id")

