# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['IPAMPoolArgs', 'IPAMPool']

@pulumi.input_type
class IPAMPoolArgs:
    def __init__(__self__, *,
                 address_family: pulumi.Input[str],
                 ipam_scope_id: pulumi.Input[str],
                 allocation_default_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]] = None,
                 auto_import: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 provisioned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolProvisionedCidrArgs']]]] = None,
                 publicly_advertisable: Optional[pulumi.Input[bool]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]] = None):
        """
        The set of arguments for constructing a IPAMPool resource.
        :param pulumi.Input[str] address_family: The address family of the address space in this pool. Either IPv4 or IPv6.
        :param pulumi.Input[str] ipam_scope_id: The Id of the scope this pool is a part of.
        :param pulumi.Input[int] allocation_default_netmask_length: The default netmask length for allocations made from this pool. This value is used when the netmask length of an allocation isn't specified.
        :param pulumi.Input[int] allocation_max_netmask_length: The maximum allowed netmask length for allocations made from this pool.
        :param pulumi.Input[int] allocation_min_netmask_length: The minimum allowed netmask length for allocations made from this pool.
        :param pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]] allocation_resource_tags: When specified, an allocation will not be allowed unless a resource has a matching set of tags.
        :param pulumi.Input[bool] auto_import: Determines what to do if IPAM discovers resources that haven't been assigned an allocation. If set to true, an allocation will be made automatically.
        :param pulumi.Input[str] locale: The region of this pool. If not set, this will default to "None" which will disable non-custom allocations. If the locale has been specified for the source pool, this value must match.
        :param pulumi.Input[Sequence[pulumi.Input['IPAMPoolProvisionedCidrArgs']]] provisioned_cidrs: A list of cidrs representing the address space available for allocation in this pool.
        :param pulumi.Input[bool] publicly_advertisable: Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        :param pulumi.Input[str] source_ipam_pool_id: The Id of this pool's source. If set, all space provisioned in this pool must be free space provisioned in the parent pool.
        :param pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "address_family", address_family)
        pulumi.set(__self__, "ipam_scope_id", ipam_scope_id)
        if allocation_default_netmask_length is not None:
            pulumi.set(__self__, "allocation_default_netmask_length", allocation_default_netmask_length)
        if allocation_max_netmask_length is not None:
            pulumi.set(__self__, "allocation_max_netmask_length", allocation_max_netmask_length)
        if allocation_min_netmask_length is not None:
            pulumi.set(__self__, "allocation_min_netmask_length", allocation_min_netmask_length)
        if allocation_resource_tags is not None:
            pulumi.set(__self__, "allocation_resource_tags", allocation_resource_tags)
        if auto_import is not None:
            pulumi.set(__self__, "auto_import", auto_import)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if provisioned_cidrs is not None:
            pulumi.set(__self__, "provisioned_cidrs", provisioned_cidrs)
        if publicly_advertisable is not None:
            pulumi.set(__self__, "publicly_advertisable", publicly_advertisable)
        if source_ipam_pool_id is not None:
            pulumi.set(__self__, "source_ipam_pool_id", source_ipam_pool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> pulumi.Input[str]:
        """
        The address family of the address space in this pool. Either IPv4 or IPv6.
        """
        return pulumi.get(self, "address_family")

    @address_family.setter
    def address_family(self, value: pulumi.Input[str]):
        pulumi.set(self, "address_family", value)

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Input[str]:
        """
        The Id of the scope this pool is a part of.
        """
        return pulumi.get(self, "ipam_scope_id")

    @ipam_scope_id.setter
    def ipam_scope_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ipam_scope_id", value)

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> Optional[pulumi.Input[int]]:
        """
        The default netmask length for allocations made from this pool. This value is used when the netmask length of an allocation isn't specified.
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @allocation_default_netmask_length.setter
    def allocation_default_netmask_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_default_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum allowed netmask length for allocations made from this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @allocation_max_netmask_length.setter
    def allocation_max_netmask_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_max_netmask_length", value)

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum allowed netmask length for allocations made from this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @allocation_min_netmask_length.setter
    def allocation_min_netmask_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocation_min_netmask_length", value)

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]]:
        """
        When specified, an allocation will not be allowed unless a resource has a matching set of tags.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @allocation_resource_tags.setter
    def allocation_resource_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]]):
        pulumi.set(self, "allocation_resource_tags", value)

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines what to do if IPAM discovers resources that haven't been assigned an allocation. If set to true, an allocation will be made automatically.
        """
        return pulumi.get(self, "auto_import")

    @auto_import.setter
    def auto_import(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_import", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[str]]:
        """
        The region of this pool. If not set, this will default to "None" which will disable non-custom allocations. If the locale has been specified for the source pool, this value must match.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter(name="provisionedCidrs")
    def provisioned_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolProvisionedCidrArgs']]]]:
        """
        A list of cidrs representing the address space available for allocation in this pool.
        """
        return pulumi.get(self, "provisioned_cidrs")

    @provisioned_cidrs.setter
    def provisioned_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolProvisionedCidrArgs']]]]):
        pulumi.set(self, "provisioned_cidrs", value)

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        """
        return pulumi.get(self, "publicly_advertisable")

    @publicly_advertisable.setter
    def publicly_advertisable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_advertisable", value)

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of this pool's source. If set, all space provisioned in this pool must be free space provisioned in the parent pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @source_ipam_pool_id.setter
    def source_ipam_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ipam_pool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPAMPoolTagArgs']]]]):
        pulumi.set(self, "tags", value)


class IPAMPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_family: Optional[pulumi.Input[str]] = None,
                 allocation_default_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]]] = None,
                 auto_import: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[str]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 provisioned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolProvisionedCidrArgs']]]]] = None,
                 publicly_advertisable: Optional[pulumi.Input[bool]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Schema of AWS::EC2::IPAMPool Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_family: The address family of the address space in this pool. Either IPv4 or IPv6.
        :param pulumi.Input[int] allocation_default_netmask_length: The default netmask length for allocations made from this pool. This value is used when the netmask length of an allocation isn't specified.
        :param pulumi.Input[int] allocation_max_netmask_length: The maximum allowed netmask length for allocations made from this pool.
        :param pulumi.Input[int] allocation_min_netmask_length: The minimum allowed netmask length for allocations made from this pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]] allocation_resource_tags: When specified, an allocation will not be allowed unless a resource has a matching set of tags.
        :param pulumi.Input[bool] auto_import: Determines what to do if IPAM discovers resources that haven't been assigned an allocation. If set to true, an allocation will be made automatically.
        :param pulumi.Input[str] ipam_scope_id: The Id of the scope this pool is a part of.
        :param pulumi.Input[str] locale: The region of this pool. If not set, this will default to "None" which will disable non-custom allocations. If the locale has been specified for the source pool, this value must match.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolProvisionedCidrArgs']]]] provisioned_cidrs: A list of cidrs representing the address space available for allocation in this pool.
        :param pulumi.Input[bool] publicly_advertisable: Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        :param pulumi.Input[str] source_ipam_pool_id: The Id of this pool's source. If set, all space provisioned in this pool must be free space provisioned in the parent pool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IPAMPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema of AWS::EC2::IPAMPool Type

        :param str resource_name: The name of the resource.
        :param IPAMPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IPAMPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_family: Optional[pulumi.Input[str]] = None,
                 allocation_default_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_max_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_min_netmask_length: Optional[pulumi.Input[int]] = None,
                 allocation_resource_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]]] = None,
                 auto_import: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ipam_scope_id: Optional[pulumi.Input[str]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 provisioned_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolProvisionedCidrArgs']]]]] = None,
                 publicly_advertisable: Optional[pulumi.Input[bool]] = None,
                 source_ipam_pool_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IPAMPoolTagArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IPAMPoolArgs.__new__(IPAMPoolArgs)

            if address_family is None and not opts.urn:
                raise TypeError("Missing required property 'address_family'")
            __props__.__dict__["address_family"] = address_family
            __props__.__dict__["allocation_default_netmask_length"] = allocation_default_netmask_length
            __props__.__dict__["allocation_max_netmask_length"] = allocation_max_netmask_length
            __props__.__dict__["allocation_min_netmask_length"] = allocation_min_netmask_length
            __props__.__dict__["allocation_resource_tags"] = allocation_resource_tags
            __props__.__dict__["auto_import"] = auto_import
            __props__.__dict__["description"] = description
            if ipam_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'ipam_scope_id'")
            __props__.__dict__["ipam_scope_id"] = ipam_scope_id
            __props__.__dict__["locale"] = locale
            __props__.__dict__["provisioned_cidrs"] = provisioned_cidrs
            __props__.__dict__["publicly_advertisable"] = publicly_advertisable
            __props__.__dict__["source_ipam_pool_id"] = source_ipam_pool_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["ipam_arn"] = None
            __props__.__dict__["ipam_pool_id"] = None
            __props__.__dict__["ipam_scope_arn"] = None
            __props__.__dict__["ipam_scope_type"] = None
            __props__.__dict__["pool_depth"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
        super(IPAMPool, __self__).__init__(
            'aws-native:ec2:IPAMPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IPAMPool':
        """
        Get an existing IPAMPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IPAMPoolArgs.__new__(IPAMPoolArgs)

        __props__.__dict__["address_family"] = None
        __props__.__dict__["allocation_default_netmask_length"] = None
        __props__.__dict__["allocation_max_netmask_length"] = None
        __props__.__dict__["allocation_min_netmask_length"] = None
        __props__.__dict__["allocation_resource_tags"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_import"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["ipam_arn"] = None
        __props__.__dict__["ipam_pool_id"] = None
        __props__.__dict__["ipam_scope_arn"] = None
        __props__.__dict__["ipam_scope_id"] = None
        __props__.__dict__["ipam_scope_type"] = None
        __props__.__dict__["locale"] = None
        __props__.__dict__["pool_depth"] = None
        __props__.__dict__["provisioned_cidrs"] = None
        __props__.__dict__["publicly_advertisable"] = None
        __props__.__dict__["source_ipam_pool_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["state_message"] = None
        __props__.__dict__["tags"] = None
        return IPAMPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> pulumi.Output[str]:
        """
        The address family of the address space in this pool. Either IPv4 or IPv6.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="allocationDefaultNetmaskLength")
    def allocation_default_netmask_length(self) -> pulumi.Output[Optional[int]]:
        """
        The default netmask length for allocations made from this pool. This value is used when the netmask length of an allocation isn't specified.
        """
        return pulumi.get(self, "allocation_default_netmask_length")

    @property
    @pulumi.getter(name="allocationMaxNetmaskLength")
    def allocation_max_netmask_length(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum allowed netmask length for allocations made from this pool.
        """
        return pulumi.get(self, "allocation_max_netmask_length")

    @property
    @pulumi.getter(name="allocationMinNetmaskLength")
    def allocation_min_netmask_length(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum allowed netmask length for allocations made from this pool.
        """
        return pulumi.get(self, "allocation_min_netmask_length")

    @property
    @pulumi.getter(name="allocationResourceTags")
    def allocation_resource_tags(self) -> pulumi.Output[Optional[Sequence['outputs.IPAMPoolTag']]]:
        """
        When specified, an allocation will not be allowed unless a resource has a matching set of tags.
        """
        return pulumi.get(self, "allocation_resource_tags")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM Pool.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoImport")
    def auto_import(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines what to do if IPAM discovers resources that haven't been assigned an allocation. If set to true, an allocation will be made automatically.
        """
        return pulumi.get(self, "auto_import")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamArn")
    def ipam_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IPAM this pool is a part of.
        """
        return pulumi.get(self, "ipam_arn")

    @property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> pulumi.Output[str]:
        """
        Id of the IPAM Pool.
        """
        return pulumi.get(self, "ipam_pool_id")

    @property
    @pulumi.getter(name="ipamScopeArn")
    def ipam_scope_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the scope this pool is a part of.
        """
        return pulumi.get(self, "ipam_scope_arn")

    @property
    @pulumi.getter(name="ipamScopeId")
    def ipam_scope_id(self) -> pulumi.Output[str]:
        """
        The Id of the scope this pool is a part of.
        """
        return pulumi.get(self, "ipam_scope_id")

    @property
    @pulumi.getter(name="ipamScopeType")
    def ipam_scope_type(self) -> pulumi.Output['IPAMPoolIpamScopeType']:
        """
        Determines whether this scope contains publicly routable space or space for a private network
        """
        return pulumi.get(self, "ipam_scope_type")

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Output[Optional[str]]:
        """
        The region of this pool. If not set, this will default to "None" which will disable non-custom allocations. If the locale has been specified for the source pool, this value must match.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter(name="poolDepth")
    def pool_depth(self) -> pulumi.Output[int]:
        """
        The depth of this pool in the source pool hierarchy.
        """
        return pulumi.get(self, "pool_depth")

    @property
    @pulumi.getter(name="provisionedCidrs")
    def provisioned_cidrs(self) -> pulumi.Output[Optional[Sequence['outputs.IPAMPoolProvisionedCidr']]]:
        """
        A list of cidrs representing the address space available for allocation in this pool.
        """
        return pulumi.get(self, "provisioned_cidrs")

    @property
    @pulumi.getter(name="publiclyAdvertisable")
    def publicly_advertisable(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        """
        return pulumi.get(self, "publicly_advertisable")

    @property
    @pulumi.getter(name="sourceIpamPoolId")
    def source_ipam_pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of this pool's source. If set, all space provisioned in this pool must be free space provisioned in the parent pool.
        """
        return pulumi.get(self, "source_ipam_pool_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['IPAMPoolState']:
        """
        The state of this pool. This can be one of the following values: "create-in-progress", "create-complete", "modify-in-progress", "modify-complete", "delete-in-progress", or "delete-complete"
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[str]:
        """
        An explanation of how the pool arrived at it current state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.IPAMPoolTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

