# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationTaskArgs', 'ReplicationTask']

@pulumi.input_type
class ReplicationTaskArgs:
    def __init__(__self__, *,
                 migration_type: pulumi.Input[str],
                 replication_instance_arn: pulumi.Input[str],
                 source_endpoint_arn: pulumi.Input[str],
                 table_mappings: pulumi.Input[str],
                 target_endpoint_arn: pulumi.Input[str],
                 cdc_start_position: Optional[pulumi.Input[str]] = None,
                 cdc_start_time: Optional[pulumi.Input[float]] = None,
                 cdc_stop_position: Optional[pulumi.Input[str]] = None,
                 replication_task_identifier: Optional[pulumi.Input[str]] = None,
                 replication_task_settings: Optional[pulumi.Input[str]] = None,
                 resource_identifier: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationTaskTagArgs']]]] = None,
                 task_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ReplicationTask resource.
        """
        pulumi.set(__self__, "migration_type", migration_type)
        pulumi.set(__self__, "replication_instance_arn", replication_instance_arn)
        pulumi.set(__self__, "source_endpoint_arn", source_endpoint_arn)
        pulumi.set(__self__, "table_mappings", table_mappings)
        pulumi.set(__self__, "target_endpoint_arn", target_endpoint_arn)
        if cdc_start_position is not None:
            pulumi.set(__self__, "cdc_start_position", cdc_start_position)
        if cdc_start_time is not None:
            pulumi.set(__self__, "cdc_start_time", cdc_start_time)
        if cdc_stop_position is not None:
            pulumi.set(__self__, "cdc_stop_position", cdc_stop_position)
        if replication_task_identifier is not None:
            pulumi.set(__self__, "replication_task_identifier", replication_task_identifier)
        if replication_task_settings is not None:
            pulumi.set(__self__, "replication_task_settings", replication_task_settings)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_data is not None:
            pulumi.set(__self__, "task_data", task_data)

    @property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_type", value)

    @property
    @pulumi.getter(name="replicationInstanceArn")
    def replication_instance_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "replication_instance_arn")

    @replication_instance_arn.setter
    def replication_instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_instance_arn", value)

    @property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source_endpoint_arn")

    @source_endpoint_arn.setter
    def source_endpoint_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_endpoint_arn", value)

    @property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Input[str]:
        return pulumi.get(self, "table_mappings")

    @table_mappings.setter
    def table_mappings(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_mappings", value)

    @property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "target_endpoint_arn")

    @target_endpoint_arn.setter
    def target_endpoint_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_endpoint_arn", value)

    @property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cdc_start_position")

    @cdc_start_position.setter
    def cdc_start_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cdc_start_position", value)

    @property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "cdc_start_time")

    @cdc_start_time.setter
    def cdc_start_time(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cdc_start_time", value)

    @property
    @pulumi.getter(name="cdcStopPosition")
    def cdc_stop_position(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cdc_stop_position")

    @cdc_stop_position.setter
    def cdc_stop_position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cdc_stop_position", value)

    @property
    @pulumi.getter(name="replicationTaskIdentifier")
    def replication_task_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "replication_task_identifier")

    @replication_task_identifier.setter
    def replication_task_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_task_identifier", value)

    @property
    @pulumi.getter(name="replicationTaskSettings")
    def replication_task_settings(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "replication_task_settings")

    @replication_task_settings.setter
    def replication_task_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_task_settings", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationTaskTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationTaskTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskData")
    def task_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "task_data")

    @task_data.setter
    def task_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_data", value)


warnings.warn("""ReplicationTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class ReplicationTask(pulumi.CustomResource):
    warnings.warn("""ReplicationTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdc_start_position: Optional[pulumi.Input[str]] = None,
                 cdc_start_time: Optional[pulumi.Input[float]] = None,
                 cdc_stop_position: Optional[pulumi.Input[str]] = None,
                 migration_type: Optional[pulumi.Input[str]] = None,
                 replication_instance_arn: Optional[pulumi.Input[str]] = None,
                 replication_task_identifier: Optional[pulumi.Input[str]] = None,
                 replication_task_settings: Optional[pulumi.Input[str]] = None,
                 resource_identifier: Optional[pulumi.Input[str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[str]] = None,
                 table_mappings: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationTaskTagArgs']]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[str]] = None,
                 task_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::DMS::ReplicationTask

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::DMS::ReplicationTask

        :param str resource_name: The name of the resource.
        :param ReplicationTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdc_start_position: Optional[pulumi.Input[str]] = None,
                 cdc_start_time: Optional[pulumi.Input[float]] = None,
                 cdc_stop_position: Optional[pulumi.Input[str]] = None,
                 migration_type: Optional[pulumi.Input[str]] = None,
                 replication_instance_arn: Optional[pulumi.Input[str]] = None,
                 replication_task_identifier: Optional[pulumi.Input[str]] = None,
                 replication_task_settings: Optional[pulumi.Input[str]] = None,
                 resource_identifier: Optional[pulumi.Input[str]] = None,
                 source_endpoint_arn: Optional[pulumi.Input[str]] = None,
                 table_mappings: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationTaskTagArgs']]]]] = None,
                 target_endpoint_arn: Optional[pulumi.Input[str]] = None,
                 task_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        pulumi.log.warn("""ReplicationTask is deprecated: ReplicationTask is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationTaskArgs.__new__(ReplicationTaskArgs)

            __props__.__dict__["cdc_start_position"] = cdc_start_position
            __props__.__dict__["cdc_start_time"] = cdc_start_time
            __props__.__dict__["cdc_stop_position"] = cdc_stop_position
            if migration_type is None and not opts.urn:
                raise TypeError("Missing required property 'migration_type'")
            __props__.__dict__["migration_type"] = migration_type
            if replication_instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'replication_instance_arn'")
            __props__.__dict__["replication_instance_arn"] = replication_instance_arn
            __props__.__dict__["replication_task_identifier"] = replication_task_identifier
            __props__.__dict__["replication_task_settings"] = replication_task_settings
            __props__.__dict__["resource_identifier"] = resource_identifier
            if source_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint_arn'")
            __props__.__dict__["source_endpoint_arn"] = source_endpoint_arn
            if table_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'table_mappings'")
            __props__.__dict__["table_mappings"] = table_mappings
            __props__.__dict__["tags"] = tags
            if target_endpoint_arn is None and not opts.urn:
                raise TypeError("Missing required property 'target_endpoint_arn'")
            __props__.__dict__["target_endpoint_arn"] = target_endpoint_arn
            __props__.__dict__["task_data"] = task_data
        super(ReplicationTask, __self__).__init__(
            'aws-native:dms:ReplicationTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ReplicationTask':
        """
        Get an existing ReplicationTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReplicationTaskArgs.__new__(ReplicationTaskArgs)

        __props__.__dict__["cdc_start_position"] = None
        __props__.__dict__["cdc_start_time"] = None
        __props__.__dict__["cdc_stop_position"] = None
        __props__.__dict__["migration_type"] = None
        __props__.__dict__["replication_instance_arn"] = None
        __props__.__dict__["replication_task_identifier"] = None
        __props__.__dict__["replication_task_settings"] = None
        __props__.__dict__["resource_identifier"] = None
        __props__.__dict__["source_endpoint_arn"] = None
        __props__.__dict__["table_mappings"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_endpoint_arn"] = None
        __props__.__dict__["task_data"] = None
        return ReplicationTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cdcStartPosition")
    def cdc_start_position(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cdc_start_position")

    @property
    @pulumi.getter(name="cdcStartTime")
    def cdc_start_time(self) -> pulumi.Output[Optional[float]]:
        return pulumi.get(self, "cdc_start_time")

    @property
    @pulumi.getter(name="cdcStopPosition")
    def cdc_stop_position(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cdc_stop_position")

    @property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "migration_type")

    @property
    @pulumi.getter(name="replicationInstanceArn")
    def replication_instance_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "replication_instance_arn")

    @property
    @pulumi.getter(name="replicationTaskIdentifier")
    def replication_task_identifier(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "replication_task_identifier")

    @property
    @pulumi.getter(name="replicationTaskSettings")
    def replication_task_settings(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "replication_task_settings")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "resource_identifier")

    @property
    @pulumi.getter(name="sourceEndpointArn")
    def source_endpoint_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "source_endpoint_arn")

    @property
    @pulumi.getter(name="tableMappings")
    def table_mappings(self) -> pulumi.Output[str]:
        return pulumi.get(self, "table_mappings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationTaskTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetEndpointArn")
    def target_endpoint_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "target_endpoint_arn")

    @property
    @pulumi.getter(name="taskData")
    def task_data(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "task_data")

