# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetMemberInvitationResult',
    'AwaitableGetMemberInvitationResult',
    'get_member_invitation',
    'get_member_invitation_output',
]

@pulumi.output_type
class GetMemberInvitationResult:
    def __init__(__self__, disable_email_notification=None, member_email_address=None, message=None):
        if disable_email_notification and not isinstance(disable_email_notification, bool):
            raise TypeError("Expected argument 'disable_email_notification' to be a bool")
        pulumi.set(__self__, "disable_email_notification", disable_email_notification)
        if member_email_address and not isinstance(member_email_address, str):
            raise TypeError("Expected argument 'member_email_address' to be a str")
        pulumi.set(__self__, "member_email_address", member_email_address)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="disableEmailNotification")
    def disable_email_notification(self) -> Optional[bool]:
        """
        When set to true, invitation emails are not sent to the member accounts. Member accounts must still accept the invitation before they are added to the behavior graph. Updating this field has no effect.
        """
        return pulumi.get(self, "disable_email_notification")

    @property
    @pulumi.getter(name="memberEmailAddress")
    def member_email_address(self) -> Optional[str]:
        """
        The root email address for the account to be invited, for validation. Updating this field has no effect.
        """
        return pulumi.get(self, "member_email_address")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A message to be included in the email invitation sent to the invited account. Updating this field has no effect.
        """
        return pulumi.get(self, "message")


class AwaitableGetMemberInvitationResult(GetMemberInvitationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMemberInvitationResult(
            disable_email_notification=self.disable_email_notification,
            member_email_address=self.member_email_address,
            message=self.message)


def get_member_invitation(graph_arn: Optional[str] = None,
                          member_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMemberInvitationResult:
    """
    Resource schema for AWS::Detective::MemberInvitation


    :param str graph_arn: The ARN of the graph to which the member account will be invited
    :param str member_id: The AWS account ID to be invited to join the graph as a member
    """
    __args__ = dict()
    __args__['graphArn'] = graph_arn
    __args__['memberId'] = member_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:detective:getMemberInvitation', __args__, opts=opts, typ=GetMemberInvitationResult).value

    return AwaitableGetMemberInvitationResult(
        disable_email_notification=__ret__.disable_email_notification,
        member_email_address=__ret__.member_email_address,
        message=__ret__.message)


@_utilities.lift_output_func(get_member_invitation)
def get_member_invitation_output(graph_arn: Optional[pulumi.Input[str]] = None,
                                 member_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMemberInvitationResult]:
    """
    Resource schema for AWS::Detective::MemberInvitation


    :param str graph_arn: The ARN of the graph to which the member account will be invited
    :param str member_id: The AWS account ID to be invited to join the graph as a member
    """
    ...
