# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RequestValidatorArgs', 'RequestValidator']

@pulumi.input_type
class RequestValidatorArgs:
    def __init__(__self__, *,
                 rest_api_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 validate_request_body: Optional[pulumi.Input[bool]] = None,
                 validate_request_parameters: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a RequestValidator resource.
        :param pulumi.Input[str] rest_api_id: The identifier of the targeted API entity.
        :param pulumi.Input[str] name: Name of the request validator.
        :param pulumi.Input[bool] validate_request_body: Indicates whether to validate the request body according to the configured schema for the targeted API and method. 
        :param pulumi.Input[bool] validate_request_parameters: Indicates whether to validate request parameters.
        """
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if validate_request_body is not None:
            pulumi.set(__self__, "validate_request_body", validate_request_body)
        if validate_request_parameters is not None:
            pulumi.set(__self__, "validate_request_parameters", validate_request_parameters)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[str]:
        """
        The identifier of the targeted API entity.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the request validator.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="validateRequestBody")
    def validate_request_body(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to validate the request body according to the configured schema for the targeted API and method. 
        """
        return pulumi.get(self, "validate_request_body")

    @validate_request_body.setter
    def validate_request_body(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_request_body", value)

    @property
    @pulumi.getter(name="validateRequestParameters")
    def validate_request_parameters(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to validate request parameters.
        """
        return pulumi.get(self, "validate_request_parameters")

    @validate_request_parameters.setter
    def validate_request_parameters(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_request_parameters", value)


class RequestValidator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 validate_request_body: Optional[pulumi.Input[bool]] = None,
                 validate_request_parameters: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ApiGateway::RequestValidator

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the request validator.
        :param pulumi.Input[str] rest_api_id: The identifier of the targeted API entity.
        :param pulumi.Input[bool] validate_request_body: Indicates whether to validate the request body according to the configured schema for the targeted API and method. 
        :param pulumi.Input[bool] validate_request_parameters: Indicates whether to validate request parameters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RequestValidatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ApiGateway::RequestValidator

        :param str resource_name: The name of the resource.
        :param RequestValidatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RequestValidatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rest_api_id: Optional[pulumi.Input[str]] = None,
                 validate_request_body: Optional[pulumi.Input[bool]] = None,
                 validate_request_parameters: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RequestValidatorArgs.__new__(RequestValidatorArgs)

            __props__.__dict__["name"] = name
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
            __props__.__dict__["validate_request_body"] = validate_request_body
            __props__.__dict__["validate_request_parameters"] = validate_request_parameters
            __props__.__dict__["request_validator_id"] = None
        super(RequestValidator, __self__).__init__(
            'aws-native:apigateway:RequestValidator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RequestValidator':
        """
        Get an existing RequestValidator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RequestValidatorArgs.__new__(RequestValidatorArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["request_validator_id"] = None
        __props__.__dict__["rest_api_id"] = None
        __props__.__dict__["validate_request_body"] = None
        __props__.__dict__["validate_request_parameters"] = None
        return RequestValidator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the request validator.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestValidatorId")
    def request_validator_id(self) -> pulumi.Output[str]:
        """
        ID of the request validator.
        """
        return pulumi.get(self, "request_validator_id")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[str]:
        """
        The identifier of the targeted API entity.
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter(name="validateRequestBody")
    def validate_request_body(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to validate the request body according to the configured schema for the targeted API and method. 
        """
        return pulumi.get(self, "validate_request_body")

    @property
    @pulumi.getter(name="validateRequestParameters")
    def validate_request_parameters(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to validate request parameters.
        """
        return pulumi.get(self, "validate_request_parameters")

