# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .custom_payment_method_schema_field_type import CustomPaymentMethodSchemaFieldType


class CustomPaymentMethodSchemaField(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import CustomPaymentMethodSchemaField

    CustomPaymentMethodSchemaField(
        name="payToTheOrderOf",
        display_name="Pay To The Order Of",
        type="text",
        optional=False,
    )
    """

    name: str
    display_name: typing.Optional[str] = pydantic_v1.Field(alias="displayName", default=None)
    type: CustomPaymentMethodSchemaFieldType
    optional: bool = pydantic_v1.Field()
    """
    Indicates whether this field is optional
    """

    use_as_account_name: typing.Optional[bool] = pydantic_v1.Field(alias="useAsAccountName", default=None)
    """
    Indicates whether this field should be used as the name of the payment method. Only one field can be used as the name. Will set the accountName field of the payment method to the value of this field.
    """

    use_as_account_number: typing.Optional[bool] = pydantic_v1.Field(alias="useAsAccountNumber", default=None)
    """
    Indicates whether this field should be used as the account number of the payment method. Only one field can be used as the account number. Will set the accountNumber field of the payment method to the value of this field.
    """

    options: typing.Optional[typing.List[str]] = pydantic_v1.Field(default=None)
    """
    When type is 'select', provide options that can be selected
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
