# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .bank_account_check_options import BankAccountCheckOptions
from .bank_type import BankType
from .payment_method_base_request import PaymentMethodBaseRequest
from .plaid_link_request import PlaidLinkRequest


class BankAccountRequest(PaymentMethodBaseRequest):
    account_name: typing.Optional[str] = pydantic_v1.Field(alias="accountName", default=None)
    """
    The name of the account. For example "My Checking Account" or "Property XYZ Checking"
    """

    bank_name: typing.Optional[str] = pydantic_v1.Field(alias="bankName", default=None)
    """
    The name of the bank. This is now automatically set when the bank account is linked.
    """

    routing_number: str = pydantic_v1.Field(alias="routingNumber")
    account_number: str = pydantic_v1.Field(alias="accountNumber")
    account_type: BankType = pydantic_v1.Field(alias="accountType")
    plaid: typing.Optional[PlaidLinkRequest] = pydantic_v1.Field(default=None)
    """
    If provided, will link a bank account using Plaid Link
    """

    check_options: typing.Optional[BankAccountCheckOptions] = pydantic_v1.Field(alias="checkOptions", default=None)
    """
    If this bank account supports check printing, use this to enable check printing and set the check options. Checks will be printed directly from the bank account.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
