# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .color_scheme_response import ColorSchemeResponse
from .email_provider_response import EmailProviderResponse
from .external_accounting_system_provider_response import ExternalAccountingSystemProviderResponse
from .metadata_schema import MetadataSchema
from .onboarding_options_response import OnboardingOptionsResponse
from .organization_id import OrganizationId
from .payment_methods_response import PaymentMethodsResponse


class OrganizationResponse(pydantic_v1.BaseModel):
    id: OrganizationId
    sandbox: bool
    name: str
    logo_url: typing.Optional[str] = pydantic_v1.Field(alias="logoUrl", default=None)
    website_url: typing.Optional[str] = pydantic_v1.Field(alias="websiteUrl", default=None)
    support_email: typing.Optional[str] = pydantic_v1.Field(alias="supportEmail", default=None)
    payment_methods: typing.Optional[PaymentMethodsResponse] = pydantic_v1.Field(alias="paymentMethods", default=None)
    email_provider: typing.Optional[EmailProviderResponse] = pydantic_v1.Field(alias="emailProvider", default=None)
    external_accounting_system_provider: typing.Optional[ExternalAccountingSystemProviderResponse] = pydantic_v1.Field(
        alias="externalAccountingSystemProvider", default=None
    )
    color_scheme: typing.Optional[ColorSchemeResponse] = pydantic_v1.Field(alias="colorScheme", default=None)
    payee_onboarding_options: typing.Optional[OnboardingOptionsResponse] = pydantic_v1.Field(
        alias="payeeOnboardingOptions", default=None
    )
    payor_onboarding_options: typing.Optional[OnboardingOptionsResponse] = pydantic_v1.Field(
        alias="payorOnboardingOptions", default=None
    )
    metadata_schema: typing.Optional[typing.List[MetadataSchema]] = pydantic_v1.Field(
        alias="metadataSchema", default=None
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
