# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .metadata_show_conditions import MetadataShowConditions
from .metadata_type import MetadataType
from .metadata_validation_rule import MetadataValidationRule


class MetadataSchema(pydantic_v1.BaseModel):
    key: str
    display_name: str = pydantic_v1.Field(alias="displayName")
    description: typing.Optional[str] = None
    line_item: typing.Optional[bool] = pydantic_v1.Field(alias="lineItem", default=None)
    """
    Whether or not this field should be shown on line items. If true, this field will be shown on each line item. If false, the field will be shown on the invoice level. Defaults to false.
    """

    type: MetadataType
    allow_multiple: typing.Optional[bool] = pydantic_v1.Field(alias="allowMultiple", default=None)
    """
    Whether or not multiple values are allowed for this field. Defaults to false. If true, the value will be a list of the specified type.
    """

    validation_rules: typing.Optional[MetadataValidationRule] = pydantic_v1.Field(alias="validationRules", default=None)
    """
    Validation rules are currently only supported for STRING types.
    """

    show_conditions: typing.Optional[MetadataShowConditions] = pydantic_v1.Field(alias="showConditions", default=None)
    """
    A list of conditional rules that determine whether or not this field should be shown. The field will only be shown if all of the conditions are met. If no conditions are specified, the field will always be shown.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
