# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..commons.errors.bad_request import BadRequest
from ..commons.errors.conflict import Conflict
from ..commons.errors.forbidden import Forbidden
from ..commons.errors.internal_server_error import InternalServerError
from ..commons.errors.not_found import NotFound
from ..commons.errors.unauthorized import Unauthorized
from ..commons.errors.unimplemented import Unimplemented
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..email_log_types.types.email_log_response import EmailLogResponse
from ..organization_types.types.color_scheme_request import ColorSchemeRequest
from ..organization_types.types.email_provider_request import EmailProviderRequest
from ..organization_types.types.external_accounting_system_provider_request import (
    ExternalAccountingSystemProviderRequest,
)
from ..organization_types.types.metadata_schema import MetadataSchema
from ..organization_types.types.onboarding_options_request import OnboardingOptionsRequest
from ..organization_types.types.organization_response import OrganizationResponse
from ..organization_types.types.payment_methods_request import PaymentMethodsRequest
from .notification_configuration.client import AsyncNotificationConfigurationClient, NotificationConfigurationClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OrganizationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.notification_configuration = NotificationConfigurationClient(client_wrapper=self._client_wrapper)

    def get(
        self,
        *,
        payment_methods: typing.Optional[bool] = None,
        email_provider: typing.Optional[bool] = None,
        external_accounting_system_provider: typing.Optional[bool] = None,
        color_scheme: typing.Optional[bool] = None,
        payee_onboarding_options: typing.Optional[bool] = None,
        payor_onboarding_options: typing.Optional[bool] = None,
        metadata_schema: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationResponse:
        """
        Get current organization information

        Parameters
        ----------
        payment_methods : typing.Optional[bool]
            include supported payment methods in response

        email_provider : typing.Optional[bool]
            include email provider info in response

        external_accounting_system_provider : typing.Optional[bool]
            include external accounting system provider info in response

        color_scheme : typing.Optional[bool]
            include color scheme info in response

        payee_onboarding_options : typing.Optional[bool]
            include payee onboarding options in response

        payor_onboarding_options : typing.Optional[bool]
            include payor onboarding options in response

        metadata_schema : typing.Optional[bool]
            include metadata schema in response

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.organization.get(
            payment_methods=True,
            email_provider=True,
            external_accounting_system_provider=True,
            color_scheme=True,
            payee_onboarding_options=True,
            payor_onboarding_options=True,
            metadata_schema=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "organization",
            method="GET",
            params={
                "paymentMethods": payment_methods,
                "emailProvider": email_provider,
                "externalAccountingSystemProvider": external_accounting_system_provider,
                "colorScheme": color_scheme,
                "payeeOnboardingOptions": payee_onboarding_options,
                "payorOnboardingOptions": payor_onboarding_options,
                "metadataSchema": metadata_schema,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OrganizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        *,
        name: typing.Optional[str] = OMIT,
        logo: typing.Optional[str] = OMIT,
        website_url: typing.Optional[str] = OMIT,
        support_email: typing.Optional[str] = OMIT,
        payment_methods: typing.Optional[PaymentMethodsRequest] = OMIT,
        email_provider: typing.Optional[EmailProviderRequest] = OMIT,
        external_accounting_system_provider: typing.Optional[ExternalAccountingSystemProviderRequest] = OMIT,
        color_scheme: typing.Optional[ColorSchemeRequest] = OMIT,
        payee_onboarding_options: typing.Optional[OnboardingOptionsRequest] = OMIT,
        payor_onboarding_options: typing.Optional[OnboardingOptionsRequest] = OMIT,
        metadata_schema: typing.Optional[typing.Sequence[MetadataSchema]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationResponse:
        """
        Update current organization

        Parameters
        ----------
        name : typing.Optional[str]

        logo : typing.Optional[str]

        website_url : typing.Optional[str]

        support_email : typing.Optional[str]

        payment_methods : typing.Optional[PaymentMethodsRequest]

        email_provider : typing.Optional[EmailProviderRequest]

        external_accounting_system_provider : typing.Optional[ExternalAccountingSystemProviderRequest]

        color_scheme : typing.Optional[ColorSchemeRequest]

        payee_onboarding_options : typing.Optional[OnboardingOptionsRequest]

        payor_onboarding_options : typing.Optional[OnboardingOptionsRequest]

        metadata_schema : typing.Optional[typing.Sequence[MetadataSchema]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationResponse

        Examples
        --------
        from mercoa import (
            ColorSchemeRequest,
            EmailProviderRequest,
            ExternalAccountingSystemProviderRequest_None,
            MetadataSchema,
            OnboardingOptionsRequest,
            PaymentMethodsRequest,
        )
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.organization.update(
            name="string",
            logo="string",
            website_url="string",
            support_email="string",
            payment_methods=PaymentMethodsRequest(),
            email_provider=EmailProviderRequest(),
            external_accounting_system_provider=ExternalAccountingSystemProviderRequest_None(),
            color_scheme=ColorSchemeRequest(),
            payee_onboarding_options=OnboardingOptionsRequest(),
            payor_onboarding_options=OnboardingOptionsRequest(),
            metadata_schema=[MetadataSchema()],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "organization",
            method="POST",
            json={
                "name": name,
                "logo": logo,
                "websiteUrl": website_url,
                "supportEmail": support_email,
                "paymentMethods": payment_methods,
                "emailProvider": email_provider,
                "externalAccountingSystemProvider": external_accounting_system_provider,
                "colorScheme": color_scheme,
                "payeeOnboardingOptions": payee_onboarding_options,
                "payorOnboardingOptions": payor_onboarding_options,
                "metadataSchema": metadata_schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OrganizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def email_log(
        self,
        *,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None
    ) -> EmailLogResponse:
        """
        Get log of all emails sent to this organization. Content format subject to change.

        Parameters
        ----------
        start_date : typing.Optional[dt.datetime]

        end_date : typing.Optional[dt.datetime]

        limit : typing.Optional[int]
            Number of logs to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[str]
            The ID of the log to start after. If not provided, the first page of logs will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailLogResponse

        Examples
        --------
        import datetime

        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.organization.email_log(
            start_date=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            end_date=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            limit=1,
            starting_after="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "organization/emailLog",
            method="GET",
            params={
                "startDate": serialize_datetime(start_date) if start_date is not None else None,
                "endDate": serialize_datetime(end_date) if end_date is not None else None,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EmailLogResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOrganizationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.notification_configuration = AsyncNotificationConfigurationClient(client_wrapper=self._client_wrapper)

    async def get(
        self,
        *,
        payment_methods: typing.Optional[bool] = None,
        email_provider: typing.Optional[bool] = None,
        external_accounting_system_provider: typing.Optional[bool] = None,
        color_scheme: typing.Optional[bool] = None,
        payee_onboarding_options: typing.Optional[bool] = None,
        payor_onboarding_options: typing.Optional[bool] = None,
        metadata_schema: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationResponse:
        """
        Get current organization information

        Parameters
        ----------
        payment_methods : typing.Optional[bool]
            include supported payment methods in response

        email_provider : typing.Optional[bool]
            include email provider info in response

        external_accounting_system_provider : typing.Optional[bool]
            include external accounting system provider info in response

        color_scheme : typing.Optional[bool]
            include color scheme info in response

        payee_onboarding_options : typing.Optional[bool]
            include payee onboarding options in response

        payor_onboarding_options : typing.Optional[bool]
            include payor onboarding options in response

        metadata_schema : typing.Optional[bool]
            include metadata schema in response

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.organization.get(
            payment_methods=True,
            email_provider=True,
            external_accounting_system_provider=True,
            color_scheme=True,
            payee_onboarding_options=True,
            payor_onboarding_options=True,
            metadata_schema=True,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "organization",
            method="GET",
            params={
                "paymentMethods": payment_methods,
                "emailProvider": email_provider,
                "externalAccountingSystemProvider": external_accounting_system_provider,
                "colorScheme": color_scheme,
                "payeeOnboardingOptions": payee_onboarding_options,
                "payorOnboardingOptions": payor_onboarding_options,
                "metadataSchema": metadata_schema,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OrganizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        *,
        name: typing.Optional[str] = OMIT,
        logo: typing.Optional[str] = OMIT,
        website_url: typing.Optional[str] = OMIT,
        support_email: typing.Optional[str] = OMIT,
        payment_methods: typing.Optional[PaymentMethodsRequest] = OMIT,
        email_provider: typing.Optional[EmailProviderRequest] = OMIT,
        external_accounting_system_provider: typing.Optional[ExternalAccountingSystemProviderRequest] = OMIT,
        color_scheme: typing.Optional[ColorSchemeRequest] = OMIT,
        payee_onboarding_options: typing.Optional[OnboardingOptionsRequest] = OMIT,
        payor_onboarding_options: typing.Optional[OnboardingOptionsRequest] = OMIT,
        metadata_schema: typing.Optional[typing.Sequence[MetadataSchema]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None
    ) -> OrganizationResponse:
        """
        Update current organization

        Parameters
        ----------
        name : typing.Optional[str]

        logo : typing.Optional[str]

        website_url : typing.Optional[str]

        support_email : typing.Optional[str]

        payment_methods : typing.Optional[PaymentMethodsRequest]

        email_provider : typing.Optional[EmailProviderRequest]

        external_accounting_system_provider : typing.Optional[ExternalAccountingSystemProviderRequest]

        color_scheme : typing.Optional[ColorSchemeRequest]

        payee_onboarding_options : typing.Optional[OnboardingOptionsRequest]

        payor_onboarding_options : typing.Optional[OnboardingOptionsRequest]

        metadata_schema : typing.Optional[typing.Sequence[MetadataSchema]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OrganizationResponse

        Examples
        --------
        from mercoa import (
            ColorSchemeRequest,
            EmailProviderRequest,
            ExternalAccountingSystemProviderRequest_None,
            MetadataSchema,
            OnboardingOptionsRequest,
            PaymentMethodsRequest,
        )
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.organization.update(
            name="string",
            logo="string",
            website_url="string",
            support_email="string",
            payment_methods=PaymentMethodsRequest(),
            email_provider=EmailProviderRequest(),
            external_accounting_system_provider=ExternalAccountingSystemProviderRequest_None(),
            color_scheme=ColorSchemeRequest(),
            payee_onboarding_options=OnboardingOptionsRequest(),
            payor_onboarding_options=OnboardingOptionsRequest(),
            metadata_schema=[MetadataSchema()],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "organization",
            method="POST",
            json={
                "name": name,
                "logo": logo,
                "websiteUrl": website_url,
                "supportEmail": support_email,
                "paymentMethods": payment_methods,
                "emailProvider": email_provider,
                "externalAccountingSystemProvider": external_accounting_system_provider,
                "colorScheme": color_scheme,
                "payeeOnboardingOptions": payee_onboarding_options,
                "payorOnboardingOptions": payor_onboarding_options,
                "metadataSchema": metadata_schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OrganizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def email_log(
        self,
        *,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None
    ) -> EmailLogResponse:
        """
        Get log of all emails sent to this organization. Content format subject to change.

        Parameters
        ----------
        start_date : typing.Optional[dt.datetime]

        end_date : typing.Optional[dt.datetime]

        limit : typing.Optional[int]
            Number of logs to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[str]
            The ID of the log to start after. If not provided, the first page of logs will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailLogResponse

        Examples
        --------
        import datetime

        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.organization.email_log(
            start_date=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            end_date=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            limit=1,
            starting_after="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "organization/emailLog",
            method="GET",
            params={
                "startDate": serialize_datetime(start_date) if start_date is not None else None,
                "endDate": serialize_datetime(end_date) if end_date is not None else None,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EmailLogResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
