# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.vendor_network import VendorNetwork


class OcrRequest(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import OcrRequest

    OcrRequest(
        vendor_network="entity",
        entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
        mime_type="image/png",
        image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
    )
    """

    mime_type: str = pydantic_v1.Field(alias="mimeType")
    """
    MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.
    """

    image: str = pydantic_v1.Field()
    """
    Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.
    """

    vendor_network: typing.Optional[VendorNetwork] = pydantic_v1.Field(alias="vendorNetwork", default=None)
    """
    Limit OCR vendor search to a specific network
    """

    entity_id: typing.Optional[EntityId] = pydantic_v1.Field(alias="entityId", default=None)
    """
    When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
