# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..commons.errors.bad_request import BadRequest
from ..commons.errors.conflict import Conflict
from ..commons.errors.forbidden import Forbidden
from ..commons.errors.internal_server_error import InternalServerError
from ..commons.errors.not_found import NotFound
from ..commons.errors.unauthorized import Unauthorized
from ..commons.errors.unimplemented import Unimplemented
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..entity_types.types.entity_id import EntityId
from ..entity_types.types.vendor_network import VendorNetwork
from .types.ocr_async_response import OcrAsyncResponse
from .types.ocr_job_response import OcrJobResponse
from .types.ocr_response import OcrResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OcrClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def ocr(
        self,
        *,
        mime_type: str,
        image: str,
        vendor_network: typing.Optional[VendorNetwork] = OMIT,
        entity_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrResponse:
        """
        Run OCR on an Base64 encoded image or PDF. This endpoint will block until the OCR is complete.

        Parameters
        ----------
        mime_type : str
            MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

        image : str
            Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.

        vendor_network : typing.Optional[VendorNetwork]
            Limit OCR vendor search to a specific network

        entity_id : typing.Optional[EntityId]
            When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.ocr.ocr(
            vendor_network="entity",
            entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
            mime_type="image/png",
            image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "ocr",
            method="POST",
            json={"mimeType": mime_type, "image": image, "vendorNetwork": vendor_network, "entityId": entity_id},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def run_async_ocr(
        self,
        *,
        mime_type: str,
        image: str,
        vendor_network: typing.Optional[VendorNetwork] = OMIT,
        entity_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrAsyncResponse:
        """
        Run OCR on an Base64 encoded image or PDF. This endpoint will return immediately and the OCR will be processed asynchronously.

        Parameters
        ----------
        mime_type : str
            MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

        image : str
            Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.

        vendor_network : typing.Optional[VendorNetwork]
            Limit OCR vendor search to a specific network

        entity_id : typing.Optional[EntityId]
            When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrAsyncResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.ocr.run_async_ocr(
            vendor_network="entity",
            entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
            mime_type="image/png",
            image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "ocr-async",
            method="POST",
            json={"mimeType": mime_type, "image": image, "vendorNetwork": vendor_network, "entityId": entity_id},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrAsyncResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_async_ocr(self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> OcrJobResponse:
        """
        Get the status and results of an asynchronous OCR job.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrJobResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.ocr.get_async_ocr(
            job_id="ocr_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ocr-async/{jsonable_encoder(job_id)}", method="GET", request_options=request_options
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrJobResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOcrClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def ocr(
        self,
        *,
        mime_type: str,
        image: str,
        vendor_network: typing.Optional[VendorNetwork] = OMIT,
        entity_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrResponse:
        """
        Run OCR on an Base64 encoded image or PDF. This endpoint will block until the OCR is complete.

        Parameters
        ----------
        mime_type : str
            MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

        image : str
            Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.

        vendor_network : typing.Optional[VendorNetwork]
            Limit OCR vendor search to a specific network

        entity_id : typing.Optional[EntityId]
            When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.ocr.ocr(
            vendor_network="entity",
            entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
            mime_type="image/png",
            image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ocr",
            method="POST",
            json={"mimeType": mime_type, "image": image, "vendorNetwork": vendor_network, "entityId": entity_id},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def run_async_ocr(
        self,
        *,
        mime_type: str,
        image: str,
        vendor_network: typing.Optional[VendorNetwork] = OMIT,
        entity_id: typing.Optional[EntityId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrAsyncResponse:
        """
        Run OCR on an Base64 encoded image or PDF. This endpoint will return immediately and the OCR will be processed asynchronously.

        Parameters
        ----------
        mime_type : str
            MIME type of the image. Supported types are image/png, image/jpeg, and application/pdf.

        image : str
            Base64 encoded image or PDF. PNG, JPG, and PDF are supported. 10MB max.

        vendor_network : typing.Optional[VendorNetwork]
            Limit OCR vendor search to a specific network

        entity_id : typing.Optional[EntityId]
            When using the Entity vendor network, specify the entity to use if. EntityId on an auth token will take precedence over this parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrAsyncResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.ocr.run_async_ocr(
            vendor_network="entity",
            entity_id="entity_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
            mime_type="image/png",
            image="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAIAQMAAAD+wSzIAAAABlBMVEX///+/v7+jQ3Y5AAAADklEQVQI12P4AIX8EAgALgAD/aNpbtEAAAAASUVORK5CYII",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ocr-async",
            method="POST",
            json={"mimeType": mime_type, "image": image, "vendorNetwork": vendor_network, "entityId": entity_id},
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrAsyncResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_async_ocr(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OcrJobResponse:
        """
        Get the status and results of an asynchronous OCR job.

        Parameters
        ----------
        job_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrJobResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.ocr.get_async_ocr(
            job_id="ocr_8f86116b-3b4d-4ded-99ef-3bc929d8c33c",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ocr-async/{jsonable_encoder(job_id)}", method="GET", request_options=request_options
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(OcrJobResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
