# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .bank_delivery_method import BankDeliveryMethod
from .check_delivery_method import CheckDeliveryMethod


class PaymentDestinationOptions_Check(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import PaymentDestinationOptions_Check

    PaymentDestinationOptions_Check(
        delivery="MAIL",
    )
    """

    delivery: typing.Optional[CheckDeliveryMethod] = None
    type: typing.Literal["check"] = "check"

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}


class PaymentDestinationOptions_BankAccount(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import PaymentDestinationOptions_Check

    PaymentDestinationOptions_Check(
        delivery="MAIL",
    )
    """

    delivery: typing.Optional[BankDeliveryMethod] = None
    description: typing.Optional[str] = None
    type: typing.Literal["bankAccount"] = "bankAccount"

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}


"""
from mercoa import PaymentDestinationOptions_Check

PaymentDestinationOptions_Check(
    delivery="MAIL",
)
"""
PaymentDestinationOptions = typing.Union[PaymentDestinationOptions_Check, PaymentDestinationOptions_BankAccount]
