# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ...payment_method_types.types.currency_code import CurrencyCode
from .invoice_metrics_per_date_response import InvoiceMetricsPerDateResponse


class InvoiceMetricsResponse(pydantic_v1.BaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa import InvoiceMetricsPerDateResponse, InvoiceMetricsResponse

    InvoiceMetricsResponse(
        total_amount=1000.0,
        total_count=10,
        average_amount=100.0,
        currency="USD",
        dates={
            "2021-01-01T00:00:00Z": InvoiceMetricsPerDateResponse(
                date=datetime.datetime.fromisoformat(
                    "2021-01-01 00:00:00+00:00",
                ),
                total_amount=100.0,
                total_count=1,
                average_amount=100.0,
                currency="USD",
            ),
            "2021-01-02T00:00:00Z": InvoiceMetricsPerDateResponse(
                date=datetime.datetime.fromisoformat(
                    "2021-01-02 00:00:00+00:00",
                ),
                total_amount=200.0,
                total_count=2,
                average_amount=100.0,
                currency="USD",
            ),
            "2021-01-03T00:00:00Z": InvoiceMetricsPerDateResponse(
                date=datetime.datetime.fromisoformat(
                    "2021-01-03 00:00:00+00:00",
                ),
                total_amount=400.0,
                total_count=2,
                average_amount=200.0,
                currency="USD",
            ),
        },
    )
    """

    total_amount: float = pydantic_v1.Field(alias="totalAmount")
    total_count: int = pydantic_v1.Field(alias="totalCount")
    average_amount: float = pydantic_v1.Field(alias="averageAmount")
    currency: CurrencyCode
    dates: typing.Optional[typing.Dict[str, InvoiceMetricsPerDateResponse]] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
