# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1


class InvoiceFeesResponse(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import InvoiceFeesResponse

    InvoiceFeesResponse(
        source_payment_method_fee=0.1,
        source_platform_markup_fee=0.2,
        destination_payment_method_fee=1.0,
        destination_platform_markup_fee=1.5,
    )
    """

    source_payment_method_fee: float = pydantic_v1.Field(alias="sourcePaymentMethodFee")
    """
    Fee charged to the platform (C1) for processing the source payment method. For example, credit card interchange and acquiring fees.
    """

    source_platform_markup_fee: float = pydantic_v1.Field(alias="sourcePlatformMarkupFee")
    """
    Fee charged to the payer (C2).
    """

    destination_payment_method_fee: float = pydantic_v1.Field(alias="destinationPaymentMethodFee")
    """
    Fee charged to the platform (C1) for processing the destination payment method. For example, postage for a check payment.
    """

    destination_platform_markup_fee: float = pydantic_v1.Field(alias="destinationPlatformMarkupFee")
    """
    Fee charged to the payee (C3).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
