# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ...entity_types.types.approval_policy_id import ApprovalPolicyId
from ...entity_types.types.entity_user_id import EntityUserId
from .approval_slot_id import ApprovalSlotId
from .approver_action import ApproverAction


class ApprovalSlot(pydantic_v1.BaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa import ApprovalSlot

    ApprovalSlot(
        approval_policy_id="apvl_5ce50275-1789-42ea-bc60-bb7e6d03635c",
        approval_slot_id="inap_9bb311c9-7c15-4c9e-8148-63814e0abec6",
        assigned_user_id="user_e24fc81c-c5ee-47e8-af42-4fe29d895506",
        action="APPROVE",
        eligible_user_ids=["user_e24fc81c-c5ee-47e8-af42-4fe29d895506"],
        eligible_roles=["admin"],
        date=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    approval_policy_id: ApprovalPolicyId = pydantic_v1.Field(alias="approvalPolicyId")
    """
    The identifier for the approval policy this slot is associated with.
    """

    approval_slot_id: ApprovalSlotId = pydantic_v1.Field(alias="approvalSlotId")
    """
    The identifier for this approval slot
    """

    assigned_user_id: typing.Optional[EntityUserId] = pydantic_v1.Field(alias="assignedUserId", default=None)
    action: ApproverAction
    eligible_roles: typing.List[str] = pydantic_v1.Field(alias="eligibleRoles")
    eligible_user_ids: typing.List[EntityUserId] = pydantic_v1.Field(alias="eligibleUserIds")
    date: dt.datetime = pydantic_v1.Field()
    """
    Either the date the invoice was created, date the approver was assigned, or date of last action by approver, whichever is latest.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
