# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..commons.errors.bad_request import BadRequest
from ..commons.errors.conflict import Conflict
from ..commons.errors.forbidden import Forbidden
from ..commons.errors.internal_server_error import InternalServerError
from ..commons.errors.not_found import NotFound
from ..commons.errors.unauthorized import Unauthorized
from ..commons.errors.unimplemented import Unimplemented
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pydantic_utilities import pydantic_v1
from ..core.request_options import RequestOptions
from ..invoice_types.types.invoice_fees_response import InvoiceFeesResponse
from ..invoice_types.types.payment_destination_options import PaymentDestinationOptions
from ..payment_method_types.types.currency_code import CurrencyCode
from ..payment_method_types.types.payment_method_id import PaymentMethodId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FeesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def calculate(
        self,
        *,
        amount: float,
        payment_source_id: PaymentMethodId,
        payment_destination_id: PaymentMethodId,
        currency: typing.Optional[CurrencyCode] = OMIT,
        payment_destination_options: typing.Optional[PaymentDestinationOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None
    ) -> InvoiceFeesResponse:
        """
        Calculate the fees associated with an payment given the amount, payment source, and disbursement method. Can be used to calculate fees for a payment before creating an invoice.

        Parameters
        ----------
        amount : float
            Total amount in major units. If the entered amount has more decimal places than the currency supports, trailing decimals will be truncated.

        payment_source_id : PaymentMethodId
            ID of payment source.

        payment_destination_id : PaymentMethodId
            ID of payment destination.

        currency : typing.Optional[CurrencyCode]
            Currency code for the amount. Defaults to USD.

        payment_destination_options : typing.Optional[PaymentDestinationOptions]
            Options for the payment destination. Depending on the payment destination, this may include things such as check delivery method.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InvoiceFeesResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.fees.calculate(
            amount=100.0,
            payment_source_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            payment_destination_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "fees",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "paymentSourceId": payment_source_id,
                "paymentDestinationId": payment_destination_id,
                "paymentDestinationOptions": payment_destination_options,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(InvoiceFeesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncFeesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def calculate(
        self,
        *,
        amount: float,
        payment_source_id: PaymentMethodId,
        payment_destination_id: PaymentMethodId,
        currency: typing.Optional[CurrencyCode] = OMIT,
        payment_destination_options: typing.Optional[PaymentDestinationOptions] = OMIT,
        request_options: typing.Optional[RequestOptions] = None
    ) -> InvoiceFeesResponse:
        """
        Calculate the fees associated with an payment given the amount, payment source, and disbursement method. Can be used to calculate fees for a payment before creating an invoice.

        Parameters
        ----------
        amount : float
            Total amount in major units. If the entered amount has more decimal places than the currency supports, trailing decimals will be truncated.

        payment_source_id : PaymentMethodId
            ID of payment source.

        payment_destination_id : PaymentMethodId
            ID of payment destination.

        currency : typing.Optional[CurrencyCode]
            Currency code for the amount. Defaults to USD.

        payment_destination_options : typing.Optional[PaymentDestinationOptions]
            Options for the payment destination. Depending on the payment destination, this may include things such as check delivery method.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InvoiceFeesResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.fees.calculate(
            amount=100.0,
            payment_source_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
            payment_destination_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "fees",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "paymentSourceId": payment_source_id,
                "paymentDestinationId": payment_destination_id,
                "paymentDestinationOptions": payment_destination_options,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(InvoiceFeesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
