# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .token_generation_entity_options import TokenGenerationEntityOptions
from .token_generation_invoice_options import TokenGenerationInvoiceOptions
from .token_generation_pages_options import TokenGenerationPagesOptions
from .token_generation_style_options import TokenGenerationStyleOptions
from .token_generation_vendor_options import TokenGenerationVendorOptions


class TokenGenerationOptions(pydantic_v1.BaseModel):
    expires_in: typing.Optional[str] = pydantic_v1.Field(alias="expiresIn", default=None)
    """
    Expressed in seconds or a string describing a time span. The default is 1h.
    """

    invoice: typing.Optional[TokenGenerationInvoiceOptions] = None
    pages: typing.Optional[TokenGenerationPagesOptions] = None
    style: typing.Optional[TokenGenerationStyleOptions] = None
    vendors: typing.Optional[TokenGenerationVendorOptions] = None
    entity: typing.Optional[TokenGenerationEntityOptions] = None

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
