# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1


class Responsibilities(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import Responsibilities

    Responsibilities(
        is_owner=True,
        ownership_percentage=40,
    )
    """

    job_title: typing.Optional[str] = pydantic_v1.Field(alias="jobTitle", default=None)
    is_controller: typing.Optional[bool] = pydantic_v1.Field(alias="isController", default=None)
    """
    Indicates whether this individual has significant management responsibilities within the business
    """

    is_owner: typing.Optional[bool] = pydantic_v1.Field(alias="isOwner", default=None)
    """
    Indicates whether this individual has an ownership stake of at least 25% in the business
    """

    ownership_percentage: typing.Optional[int] = pydantic_v1.Field(alias="ownershipPercentage", default=None)
    """
    Percentage of ownership in the business. Must be between 0 and 100.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
