# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ...invoice_types.types.invoice_id import InvoiceId
from .notification_id import NotificationId
from .notification_type import NotificationType


class NotificationResponse(pydantic_v1.BaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa import NotificationResponse

    NotificationResponse(
        id="notif_7df2974a-4069-454c-912f-7e58ebe030fb",
        invoice_id="inv_26e7b5d3-a739-4b23-9ad9-6aaa085f47a9",
        type="INVOICE_APPROVAL_NEEDED",
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    id: NotificationId
    invoice_id: typing.Optional[InvoiceId] = pydantic_v1.Field(alias="invoiceId", default=None)
    """
    The invoice ID that this notification is related to. This field is only present for notifications related to invoices.
    """

    type: NotificationType
    created_at: dt.datetime = pydantic_v1.Field(alias="createdAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
