# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .notification_type import NotificationType


class NotificationPolicyResponse(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import NotificationPolicyResponse

    NotificationPolicyResponse(
        disabled=False,
        additional_roles=["admin", "approver"],
        type="INVOICE_APPROVAL_NEEDED",
    )
    """

    disabled: bool = pydantic_v1.Field()
    """
    True if the selected notification type is disabled for this entity
    """

    additional_roles: typing.List[str] = pydantic_v1.Field(alias="additionalRoles")
    """
    List of user roles that should receive notifications in addition to the default users for this notification type
    """

    type: NotificationType

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
