# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .metadata_customization_request import MetadataCustomizationRequest
from .payment_method_customization_request import PaymentMethodCustomizationRequest


class EntityCustomizationResponse(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import (
        EntityCustomizationResponse,
        MetadataCustomizationRequest,
        PaymentMethodCustomizationRequest,
    )

    EntityCustomizationResponse(
        metadata=[
            MetadataCustomizationRequest(
                key="my_custom_field",
                disabled=True,
            ),
            MetadataCustomizationRequest(
                key="my_other_field",
                disabled=False,
            ),
        ],
        payment_source=[
            PaymentMethodCustomizationRequest(
                type="bankAccount",
                disabled=True,
            ),
            PaymentMethodCustomizationRequest(
                type="custom",
                schema_id="cpms_7df2974a-4069-454c-912f-7e58ebe030fb",
                disabled=True,
            ),
        ],
        backup_disbursement=[
            PaymentMethodCustomizationRequest(
                type="check",
                disabled=True,
            )
        ],
        payment_destination=[
            PaymentMethodCustomizationRequest(
                type="bankAccount",
                disabled=True,
            ),
            PaymentMethodCustomizationRequest(
                type="check",
                disabled=True,
            ),
        ],
    )
    """

    metadata: typing.List[MetadataCustomizationRequest]
    payment_source: typing.List[PaymentMethodCustomizationRequest] = pydantic_v1.Field(alias="paymentSource")
    backup_disbursement: typing.List[PaymentMethodCustomizationRequest] = pydantic_v1.Field(alias="backupDisbursement")
    payment_destination: typing.List[PaymentMethodCustomizationRequest] = pydantic_v1.Field(alias="paymentDestination")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
