# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...commons.types.address import Address
from ...commons.types.phone_number import PhoneNumber
from ...core.datetime_utils import serialize_datetime
from ...core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .business_type import BusinessType
from .tax_id import TaxId


class BusinessProfileRequest(pydantic_v1.BaseModel):
    """
    Examples
    --------
    from mercoa import Address, BusinessProfileRequest, Ein, PhoneNumber, TaxId

    BusinessProfileRequest(
        email="customer@acme.com",
        legal_business_name="Acme Inc.",
        website="http://www.acme.com",
        business_type="llc",
        phone=PhoneNumber(
            country_code="1",
            number="4155551234",
        ),
        address=Address(
            address_line_1="123 Main St",
            address_line_2="Unit 1",
            city="San Francisco",
            state_or_province="CA",
            postal_code="94105",
            country="US",
        ),
        tax_id=TaxId(
            ein=Ein(
                number="12-3456789",
            ),
        ),
    )
    """

    email: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Email address for the business. Required for KYB.
    """

    legal_business_name: str = pydantic_v1.Field(alias="legalBusinessName")
    business_type: typing.Optional[BusinessType] = pydantic_v1.Field(alias="businessType", default=None)
    phone: typing.Optional[PhoneNumber] = pydantic_v1.Field(default=None)
    """
    Phone number for the business. Required for KYB.
    """

    doing_business_as: typing.Optional[str] = pydantic_v1.Field(alias="doingBusinessAs", default=None)
    website: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Website URL for the business. Must be in the format http://www.example.com. Required for KYB if description is not provided.
    """

    description: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Description of the business. Required for KYB if website is not provided.
    """

    address: typing.Optional[Address] = pydantic_v1.Field(default=None)
    """
    Address for the business. Required for KYB.
    """

    tax_id: typing.Optional[TaxId] = pydantic_v1.Field(alias="taxId", default=None)
    """
    Tax ID for the business. Currently only EIN is supported. Required for KYB.
    """

    formation_date: typing.Optional[dt.datetime] = pydantic_v1.Field(alias="formationDate", default=None)
    """
    Date of business formation
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
