# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...commons.errors.bad_request import BadRequest
from ...commons.errors.conflict import Conflict
from ...commons.errors.forbidden import Forbidden
from ...commons.errors.internal_server_error import InternalServerError
from ...commons.errors.not_found import NotFound
from ...commons.errors.unauthorized import Unauthorized
from ...commons.errors.unimplemented import Unimplemented
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import pydantic_v1
from ...core.request_options import RequestOptions
from ...entity_types.types.entity_customization_response import EntityCustomizationResponse
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.metadata_customization_request import MetadataCustomizationRequest
from ...entity_types.types.payment_method_customization_request import PaymentMethodCustomizationRequest

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomizationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, entity_id: EntityId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityCustomizationResponse:
        """
        Get entity customization.

        Parameters
        ----------
        entity_id : EntityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityCustomizationResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.customization.get(
            entity_id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/customization", method="GET", request_options=request_options
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EntityCustomizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        entity_id: EntityId,
        *,
        metadata: typing.Sequence[MetadataCustomizationRequest],
        payment_source: typing.Sequence[PaymentMethodCustomizationRequest],
        backup_disbursement: typing.Sequence[PaymentMethodCustomizationRequest],
        payment_destination: typing.Sequence[PaymentMethodCustomizationRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityCustomizationResponse:
        """
        Update entity customization. This lets you turn off metadata and payment methods for an entity.

        Parameters
        ----------
        entity_id : EntityId

        metadata : typing.Sequence[MetadataCustomizationRequest]

        payment_source : typing.Sequence[PaymentMethodCustomizationRequest]

        backup_disbursement : typing.Sequence[PaymentMethodCustomizationRequest]

        payment_destination : typing.Sequence[PaymentMethodCustomizationRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityCustomizationResponse

        Examples
        --------
        from mercoa import (
            MetadataCustomizationRequest,
            PaymentMethodCustomizationRequest,
        )
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.customization.update(
            entity_id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
            metadata=[
                MetadataCustomizationRequest(
                    key="my_custom_field",
                    disabled=True,
                ),
                MetadataCustomizationRequest(
                    key="my_other_field",
                    disabled=False,
                ),
            ],
            payment_source=[
                PaymentMethodCustomizationRequest(
                    type="bankAccount",
                    disabled=True,
                ),
                PaymentMethodCustomizationRequest(
                    type="custom",
                    schema_id="cpms_7df2974a-4069-454c-912f-7e58ebe030fb",
                    disabled=True,
                ),
            ],
            backup_disbursement=[
                PaymentMethodCustomizationRequest(
                    type="check",
                    disabled=True,
                )
            ],
            payment_destination=[
                PaymentMethodCustomizationRequest(
                    type="bankAccount",
                    disabled=True,
                ),
                PaymentMethodCustomizationRequest(
                    type="check",
                    disabled=True,
                ),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/customization",
            method="POST",
            json={
                "metadata": metadata,
                "paymentSource": payment_source,
                "backupDisbursement": backup_disbursement,
                "paymentDestination": payment_destination,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EntityCustomizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCustomizationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, entity_id: EntityId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityCustomizationResponse:
        """
        Get entity customization.

        Parameters
        ----------
        entity_id : EntityId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityCustomizationResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.customization.get(
            entity_id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/customization", method="GET", request_options=request_options
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EntityCustomizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        entity_id: EntityId,
        *,
        metadata: typing.Sequence[MetadataCustomizationRequest],
        payment_source: typing.Sequence[PaymentMethodCustomizationRequest],
        backup_disbursement: typing.Sequence[PaymentMethodCustomizationRequest],
        payment_destination: typing.Sequence[PaymentMethodCustomizationRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityCustomizationResponse:
        """
        Update entity customization. This lets you turn off metadata and payment methods for an entity.

        Parameters
        ----------
        entity_id : EntityId

        metadata : typing.Sequence[MetadataCustomizationRequest]

        payment_source : typing.Sequence[PaymentMethodCustomizationRequest]

        backup_disbursement : typing.Sequence[PaymentMethodCustomizationRequest]

        payment_destination : typing.Sequence[PaymentMethodCustomizationRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityCustomizationResponse

        Examples
        --------
        from mercoa import (
            MetadataCustomizationRequest,
            PaymentMethodCustomizationRequest,
        )
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.customization.update(
            entity_id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
            metadata=[
                MetadataCustomizationRequest(
                    key="my_custom_field",
                    disabled=True,
                ),
                MetadataCustomizationRequest(
                    key="my_other_field",
                    disabled=False,
                ),
            ],
            payment_source=[
                PaymentMethodCustomizationRequest(
                    type="bankAccount",
                    disabled=True,
                ),
                PaymentMethodCustomizationRequest(
                    type="custom",
                    schema_id="cpms_7df2974a-4069-454c-912f-7e58ebe030fb",
                    disabled=True,
                ),
            ],
            backup_disbursement=[
                PaymentMethodCustomizationRequest(
                    type="check",
                    disabled=True,
                )
            ],
            payment_destination=[
                PaymentMethodCustomizationRequest(
                    type="bankAccount",
                    disabled=True,
                ),
                PaymentMethodCustomizationRequest(
                    type="check",
                    disabled=True,
                ),
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/customization",
            method="POST",
            json={
                "metadata": metadata,
                "paymentSource": payment_source,
                "backupDisbursement": backup_disbursement,
                "paymentDestination": payment_destination,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(EntityCustomizationResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
