# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...commons.errors.bad_request import BadRequest
from ...commons.errors.conflict import Conflict
from ...commons.errors.forbidden import Forbidden
from ...commons.errors.internal_server_error import InternalServerError
from ...commons.errors.not_found import NotFound
from ...commons.errors.unauthorized import Unauthorized
from ...commons.errors.unimplemented import Unimplemented
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import pydantic_v1
from ...core.request_options import RequestOptions
from ...entity_types.types.counterparty_customization_request import CounterpartyCustomizationRequest
from ...entity_types.types.counterparty_network_type import CounterpartyNetworkType
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.find_counterparties_response import FindCounterpartiesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CounterpartyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        logo: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters
        ----------
        entity_id : EntityId

        name : typing.Optional[str]
            Filter by counterparty name

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        logo : typing.Optional[bool]
            If true, will include counterparty logo as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.find_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payees",
            method="GET",
            params={
                "name": name,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "logo": logo,
                "counterpartyId": counterparty_id,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        logo: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters
        ----------
        entity_id : EntityId

        name : typing.Optional[str]
            Filter by counterparty name

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        logo : typing.Optional[bool]
            If true, will include counterparty logo as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.find_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payors",
            method="GET",
            params={
                "name": name,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "logo": logo,
                "counterpartyId": counterparty_id,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_payees(
        self,
        entity_id: EntityId,
        *,
        payees: typing.Sequence[EntityId],
        customizations: typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payees. If a Payee has previously been archived, unarchive the Payee.

        Parameters
        ----------
        entity_id : EntityId

        payees : typing.Sequence[EntityId]
            List of payee entity IDs to associate with the entity

        customizations : typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]]
            List of customizations to apply to the payees. If the payee is not currently a counterparty of the entity, the counterparty will be created with the provided customizations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import CounterpartyCustomizationRequest
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.add_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            customizations=[
                CounterpartyCustomizationRequest(
                    counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                    account_id="85866843",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayees",
            method="POST",
            json={"payees": payees, "customizations": customizations},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def hide_payees(
        self,
        entity_id: EntityId,
        *,
        payees: typing.Sequence[EntityId],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payees as unsearchable by Entity via Counterparty search. Invoices associated with these Payees will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId

        payees : typing.Sequence[EntityId]
            List of payee entity IDs to hide

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.hide_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayees",
            method="POST",
            json={"payees": payees},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_payors(
        self,
        entity_id: EntityId,
        *,
        payors: typing.Sequence[EntityId],
        customizations: typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payors. If a Payor has previously been archived, unarchive the Payor.

        Parameters
        ----------
        entity_id : EntityId

        payors : typing.Sequence[EntityId]
            List of payor entity IDs to associate with the entity

        customizations : typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]]
            List of customizations to apply to the payors. If the payor is not currently a counterparty of the entity, the counterparty will be created with the provided customizations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import CounterpartyCustomizationRequest
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.add_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            customizations=[
                CounterpartyCustomizationRequest(
                    counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                    account_id="85866843",
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayors",
            method="POST",
            json={"payors": payors, "customizations": customizations},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def hide_payors(
        self,
        entity_id: EntityId,
        *,
        payors: typing.Sequence[EntityId],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payors as unsearchable by Entity via Counterparty search. Invoices associated with these Payors will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId

        payors : typing.Sequence[EntityId]
            List of payor entity IDs to hide

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa.client import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.hide_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayors",
            method="POST",
            json={"payors": payors},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCounterpartyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        logo: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters
        ----------
        entity_id : EntityId

        name : typing.Optional[str]
            Filter by counterparty name

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        logo : typing.Optional[bool]
            If true, will include counterparty logo as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.find_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payees",
            method="GET",
            params={
                "name": name,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "logo": logo,
                "counterpartyId": counterparty_id,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        logo: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters
        ----------
        entity_id : EntityId

        name : typing.Optional[str]
            Filter by counterparty name

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        logo : typing.Optional[bool]
            If true, will include counterparty logo as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.find_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payors",
            method="GET",
            params={
                "name": name,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "logo": logo,
                "counterpartyId": counterparty_id,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return pydantic_v1.parse_obj_as(FindCounterpartiesResponse, _response_json)  # type: ignore
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_payees(
        self,
        entity_id: EntityId,
        *,
        payees: typing.Sequence[EntityId],
        customizations: typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payees. If a Payee has previously been archived, unarchive the Payee.

        Parameters
        ----------
        entity_id : EntityId

        payees : typing.Sequence[EntityId]
            List of payee entity IDs to associate with the entity

        customizations : typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]]
            List of customizations to apply to the payees. If the payee is not currently a counterparty of the entity, the counterparty will be created with the provided customizations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import CounterpartyCustomizationRequest
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.add_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            customizations=[
                CounterpartyCustomizationRequest(
                    counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                    account_id="85866843",
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayees",
            method="POST",
            json={"payees": payees, "customizations": customizations},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def hide_payees(
        self,
        entity_id: EntityId,
        *,
        payees: typing.Sequence[EntityId],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payees as unsearchable by Entity via Counterparty search. Invoices associated with these Payees will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId

        payees : typing.Sequence[EntityId]
            List of payee entity IDs to hide

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.hide_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayees",
            method="POST",
            json={"payees": payees},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_payors(
        self,
        entity_id: EntityId,
        *,
        payors: typing.Sequence[EntityId],
        customizations: typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payors. If a Payor has previously been archived, unarchive the Payor.

        Parameters
        ----------
        entity_id : EntityId

        payors : typing.Sequence[EntityId]
            List of payor entity IDs to associate with the entity

        customizations : typing.Optional[typing.Sequence[CounterpartyCustomizationRequest]]
            List of customizations to apply to the payors. If the payor is not currently a counterparty of the entity, the counterparty will be created with the provided customizations.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import CounterpartyCustomizationRequest
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.add_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            customizations=[
                CounterpartyCustomizationRequest(
                    counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                    account_id="85866843",
                )
            ],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayors",
            method="POST",
            json={"payors": payors, "customizations": customizations},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def hide_payors(
        self,
        entity_id: EntityId,
        *,
        payors: typing.Sequence[EntityId],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payors as unsearchable by Entity via Counterparty search. Invoices associated with these Payors will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId

        payors : typing.Sequence[EntityId]
            List of payor entity IDs to hide

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa.client import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )
        await client.entity.counterparty.hide_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayors",
            method="POST",
            json={"payors": payors},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "NotFound":
                raise NotFound(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Conflict":
                raise Conflict(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(pydantic_v1.parse_obj_as(str, _response_json["content"]))  # type: ignore
        raise ApiError(status_code=_response.status_code, body=_response_json)
