# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/distributed.core.ipynb (unless otherwise specified).

__all__ = ['distributed_preprocess']

# Cell
import operator
from typing import Callable, Dict, List, Optional, Tuple

import dask.dataframe as dd
from dask.distributed import Client, Future, default_client, futures_of, wait

from ..core import preprocessing_flow


# Cell
def distributed_preprocess(data: dd.DataFrame,
                           config: Dict,
                           client: Optional[Client] = None,
                           flow: Callable = preprocessing_flow) -> Tuple[List[Future], dd.DataFrame]:
    """Applies `flow(partition, **config)` to every partition of `data`.

    Returns futures pointing to the `TimeSeries` objects generated from each partition
    and a dask dataframe for training a distributed model."""
    client = client or default_client()

    data = client.persist(data)
    wait(data)
    partition_futures = futures_of(data)
    results_futures = client.map(flow, partition_futures, **config)

    # pure is here in case we modify in-place one of the TimeSeries and want to recompute it.
    ts_futures = client.map(operator.itemgetter(0), results_futures, pure=False)

    df_futures = client.map(operator.itemgetter(1), results_futures)
    meta = client.submit(lambda x: x.head(), df_futures[0]).result()
    train_ddf = dd.from_delayed(df_futures, meta=meta)

    return ts_futures, train_ddf