import { Eslint, EslintOptions, NodeProject, NodeProjectOptions, TypescriptConfig, TypescriptConfigOptions } from "../javascript";
import { Task } from "../task";
import { ProjenrcOptions as ProjenrcTsOptions } from "../typescript";
export interface TypeScriptProjectOptions extends NodeProjectOptions {
    /**
     * Typescript  artifacts output directory
     *
     * @default "lib"
     */
    readonly libdir?: string;
    /**
     * Typescript sources directory.
     *
     * @default "src"
     */
    readonly srcdir?: string;
    /**
     * Jest tests directory. Tests files should be named `xxx.test.ts`.
     *
     * If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
     * then tests are going to be compiled into `lib/` and executed as javascript.
     * If the test directory is outside of `src`, then we configure jest to
     * compile the code in-memory.
     *
     * @default "test"
     */
    readonly testdir?: string;
    /**
     * Setup eslint.
     *
     * @default true
     */
    readonly eslint?: boolean;
    /**
     * Eslint options
     * @default - opinionated default options
     */
    readonly eslintOptions?: EslintOptions;
    /**
     * TypeScript version to use.
     *
     * NOTE: Typescript is not semantically versioned and should remain on the
     * same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).
     *
     * @default "latest"
     */
    readonly typescriptVersion?: string;
    /**
     * Docgen by Typedoc
     *
     * @default false
     */
    readonly docgen?: boolean;
    /**
     * Docs directory
     *
     * @default "docs"
     */
    readonly docsDirectory?: string;
    /**
     * Custom TSConfig
     * @default - default options
     */
    readonly tsconfig?: TypescriptConfigOptions;
    /**
     * Custom tsconfig options for the development tsconfig.json file (used for testing).
     * @default - use the production tsconfig options
     */
    readonly tsconfigDev?: TypescriptConfigOptions;
    /**
     * The name of the development tsconfig.json file.
     *
     * @default "tsconfig.dev.json"
     */
    readonly tsconfigDevFile?: string;
    /**
     * Do not generate a `tsconfig.json` file (used by jsii projects since
     * tsconfig.json is generated by the jsii compiler).
     *
     * @default false
     */
    readonly disableTsconfig?: boolean;
    /**
     * Generate one-time sample in `src/` and `test/` if there are no files there.
     * @default true
     */
    readonly sampleCode?: boolean;
    /**
     * The .d.ts file that includes the type declarations for this module.
     * @default - .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)
     */
    readonly entrypointTypes?: string;
    /**
     * Use TypeScript for your projenrc file (`.projenrc.ts`).
     *
     * @default false
     */
    readonly projenrcTs?: boolean;
    /**
     * Options for .projenrc.ts
     */
    readonly projenrcTsOptions?: ProjenrcTsOptions;
}
/**
 * TypeScript project
 * @pjid typescript
 */
export declare class TypeScriptProject extends NodeProject {
    readonly docgen?: boolean;
    readonly docsDirectory: string;
    readonly eslint?: Eslint;
    readonly tsconfigEslint?: TypescriptConfig;
    readonly tsconfig?: TypescriptConfig;
    /**
     * A typescript configuration file which covers all files (sources, tests, projen).
     */
    readonly tsconfigDev: TypescriptConfig;
    /**
     * The directory in which the .ts sources reside.
     */
    readonly srcdir: string;
    /**
     * The directory in which compiled .js files reside.
     */
    readonly libdir: string;
    /**
     * The directory in which tests reside.
     */
    readonly testdir: string;
    /**
     * The "watch" task.
     */
    readonly watchTask: Task;
    constructor(options: TypeScriptProjectOptions);
    /**
     * Tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them
     * for us. just run them directly from javascript.
     */
    private addJestCompiled;
    private addJestNoCompile;
}
/**
 * TypeScript app.
 *
 * @pjid typescript-app
 */
export declare class TypeScriptAppProject extends TypeScriptProject {
    constructor(options: TypeScriptProjectOptions);
}
/**
 * @deprecated use `TypeScriptProject`
 */
export declare class TypeScriptLibraryProject extends TypeScriptProject {
}
/**
 * @deprecated use TypeScriptProjectOptions
 */
export interface TypeScriptLibraryProjectOptions extends TypeScriptProjectOptions {
}
/**
 * @internal
 */
export declare function mergeTsconfigOptions(...options: (TypescriptConfigOptions | undefined)[]): TypescriptConfigOptions;
