"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerComposeService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const docker_compose_1 = require("./docker-compose");
/**
 * A docker-compose service.
 */
class DockerComposeService {
    constructor(serviceName, serviceDescription) {
        if ((!serviceDescription.imageBuild && !serviceDescription.image) ||
            (serviceDescription.imageBuild && serviceDescription.image)) {
            throw new Error(`A service ${serviceName} requires exactly one of a \`imageBuild\` or \`image\` key`);
        }
        this.serviceName = serviceName;
        this.command = serviceDescription.command;
        this.image = serviceDescription.image;
        this.imageBuild = serviceDescription.imageBuild;
        this.dependsOn = serviceDescription.dependsOn ?? [];
        this.volumes = serviceDescription.volumes ?? [];
        this.networks = serviceDescription.networks ?? [];
        this.ports = serviceDescription.ports ?? [];
        this.environment = serviceDescription.environment ?? {};
        this.labels = serviceDescription.labels ?? {};
    }
    /**
     * Add a port mapping
     * @param publishedPort Published port number
     * @param targetPort Container's port number
     * @param options Port mapping options
     */
    addPort(publishedPort, targetPort, options) {
        this.ports?.push(docker_compose_1.DockerCompose.portMapping(publishedPort, targetPort, options));
    }
    /**
     * Add an environment variable
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addEnvironment(name, value) {
        this.environment[name] = value;
    }
    /**
     * Make the service depend on another service.
     * @param serviceName
     */
    addDependsOn(serviceName) {
        this.dependsOn.push(serviceName);
    }
    /**
     * Add a volume to the service.
     * @param volume
     */
    addVolume(volume) {
        this.volumes.push(volume);
    }
    /**
     * Add a network to the service.
     * @param network
     */
    addNetwork(network) {
        this.networks.push(network);
    }
    /**
     * Add a label
     * @param name environment variable name
     * @param value value of the environment variable
     */
    addLabel(name, value) {
        this.labels[name] = value;
    }
}
exports.DockerComposeService = DockerComposeService;
_a = JSII_RTTI_SYMBOL_1;
DockerComposeService[_a] = { fqn: "projen.DockerComposeService", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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