// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import React, { useCallback, useContext } from 'react';
function defaultFormatFunction(_namespace, _component, _key, provided) {
    return provided;
}
export const InternalI18nContext = React.createContext(defaultFormatFunction);
export function useInternalI18n(componentName) {
    // HACK: useContext should return the default value if a provider
    // isn't present, but some consumers mock out React.useContext globally
    // in their tests, so we can't rely on this assumption.
    const format = useContext(InternalI18nContext) || defaultFormatFunction;
    return useCallback((key, provided, customHandler) => {
        return format('@cloudscape-design/components', componentName, key, provided, customHandler);
    }, [format, componentName]);
}
//# sourceMappingURL=context.js.map