// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import React from 'react';
import clsx from 'clsx';
import useFocusVisible from '../internal/hooks/focus-visible';
import InternalIcon from '../icon/internal';
import styles from './styles.css.js';
export const TabButton = React.forwardRef(({ active, disabled, iconName, onClick, onFocus, onBlur, tabIndex, ariaHidden, ariaLabel, paneId, isRefresh, text, className, }, ref) => {
    const focusVisible = useFocusVisible();
    return (React.createElement("button", Object.assign({ className: clsx([styles['tab-button'], className], {
            [styles['tab-button--active']]: active,
            [styles['tab-button--disabled']]: disabled,
            [styles['tab-button--refresh']]: isRefresh,
        }), type: "button", onClick: onClick, onFocus: onFocus, onBlur: onBlur, disabled: disabled, ref: ref, tabIndex: tabIndex, role: "tab", "aria-selected": active, "aria-controls": paneId, "aria-hidden": ariaHidden, "aria-label": ariaLabel }, focusVisible),
        React.createElement(InternalIcon, { name: iconName }),
        " ",
        text));
});
//# sourceMappingURL=tab-button.js.map