# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.util
from typing_extensions import Literal
from .x_close_broadcaster import XCloseBroadcaster as XCloseBroadcaster_ef230d7e

class XCloseable(XCloseBroadcaster_ef230d7e):
    """
    makes it possible to release any objects in an ordered manner by using a two-step mechanism
    
    If an object should be terminated, it can be:
    
    First version gives the object no chance to disagree with that (e.g. if a process is still running and can't be canceled really). Last version provides this possibility, but can't guarantee real termination of called object. It depends from the environment of an object, if one or both mechanism are necessary.
    
    Base interface XCloseBroadcaster makes it possible that any listener which is interested on life time of listened object ...

    See Also:
        `API XCloseable <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1util_1_1XCloseable.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.util.XCloseable']

    def close(self, DeliverOwnership: bool) -> None:
        """
        try to close the object
        
        Must definitely be called before com.sun.star.lang.XComponent.dispose(). But nobody can guarantee real closing of called object - because it can disagree with that if any still running processes can't be canceled yet. It's not allowed to block this call till internal operations will be finished here. They must be canceled or call must return immediately by throwing the CloseVetoException. Otherwise (if nothing exist to disagree) it must return normally.
        
        Before any internal processes will be canceled, all registered XCloseListener must be notified. Any of them can disagree with a CloseVetoException too. It's forbidden to catch this exception inside the called close() method because the caller must get this information!
        
        If somewhere disagree with a CloseVetoException it will not clear who has to close the object again after still running processes was finished. The parameter DeliverOwnership regulate that. If it is set to FALSE the caller of the method close() will be the owner of this object in every case. Then it's not allowed to call close() from any other place (may a registered XCloseListener). If it is set to TRUE the caller gives up his ownership. If a XCloseListener throw the veto exception he will be the new owner of the closing object. This information is passed to the listener by a parameter of his notification method XCloseListener.queryClosing(). After his operations was finished he MUST try to close it again. If the closing object itself disagree by an exception and the parameter DeliverOwnership was set to TRUE the object will be his own owner with all consequences of that. Note:There is no way to get the ownership back if it was delivered!
        
        If this method was already called on an object it should return without any reaction. Normally it's possible to throw a com.sun.star.lang.DisposedException for already disposed or closed objects (which represent a com.sun.star.uno.RuntimeException and can be thrown by every interface call), but it shouldn't be used here. The veto exception should be the only way to indicates the result.

        Raises:
            CloseVetoException: ``CloseVetoException``
        """
        ...


