# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from typing_extensions import Literal
from ..lang.event_object import EventObject as EventObject_a3d70b03
from ..uno.x_interface import XInterface as XInterface_8f010a43
import typing


class CommandInfoChangeEvent(EventObject_a3d70b03):
    """
    Struct Class

    This event gets delivered whenever a XCommandInfo is changed.
    
    A CommandInfoChangeEvent object is sent to XCommandInfoChangeListeners.

    See Also:
        `API CommandInfoChangeEvent <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1CommandInfoChangeEvent.html>`_
    """
    typeName: Literal['com.sun.star.ucb.CommandInfoChangeEvent']

    def __init__(self, Source: typing.Optional[XInterface_8f010a43] = ..., Name: typing.Optional[str] = ..., Handle: typing.Optional[int] = ..., Reason: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Source (XInterface, optional): Source value.
            Name (str, optional): Name value.
            Handle (int, optional): Handle value.
            Reason (int, optional): Reason value.
        """
        ...


    @property
    def Name(self) -> str:
        """
        contains the name of the command.
        """
        ...


    @property
    def Handle(self) -> int:
        """
        contains the implementation handle for the command.
        
        May be -1 if the implementation has no handle.
        """
        ...


    @property
    def Reason(self) -> int:
        """
        contains the reason for the event.
        
        The value can be one of the CommandInfoChange constants.
        """
        ...


