# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.table
# Libre Office Version: 7.4
from typing_extensions import Literal
from .border_line import BorderLine as BorderLine_a3f80af6
from ..util.color import Color as Color_68e908c5
import typing


class BorderLine2(BorderLine_a3f80af6):
    """
    Struct Class

    A border line, extended with line style.
    
    **since**
    
        LibreOffice 3.4

    See Also:
        `API BorderLine2 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1table_1_1BorderLine2.html>`_
    """
    typeName: Literal['com.sun.star.table.BorderLine2']

    def __init__(self, Color: typing.Optional[Color_68e908c5] = ..., InnerLineWidth: typing.Optional[int] = ..., OuterLineWidth: typing.Optional[int] = ..., LineDistance: typing.Optional[int] = ..., LineStyle: typing.Optional[int] = ..., LineWidth: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Color (Color, optional): Color value.
            InnerLineWidth (int, optional): InnerLineWidth value.
            OuterLineWidth (int, optional): OuterLineWidth value.
            LineDistance (int, optional): LineDistance value.
            LineStyle (int, optional): LineStyle value.
            LineWidth (int, optional): LineWidth value.
        """
        ...


    @property
    def LineStyle(self) -> int:
        """
        Style of the border.
        """
        ...


    @property
    def LineWidth(self) -> int:
        """
        Width of the border, this is the base to compute all the lines and gaps widths.
        
        These widths computations are based on the LineStyle property
        
        This property is prevailing on the old Out, In and Dist width from BorderLine. If this property is set to 0, then the other widths will be used to guess the border width.
        """
        ...


