# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.system.windows
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing


class JumpListItem(object):
    """
    Struct Class

    Specifies an item for com.sun.star.system.windows.XJumpList .
    
    **since**
    
        LibreOffice 7.4

    See Also:
        `API JumpListItem <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1system_1_1windows_1_1JumpListItem.html>`_
    """
    typeName: Literal['com.sun.star.system.windows.JumpListItem']

    def __init__(self, name: typing.Optional[str] = ..., description: typing.Optional[str] = ..., arguments: typing.Optional[str] = ..., iconPath: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            name (str, optional): name value.
            description (str, optional): description value.
            arguments (str, optional): arguments value.
            iconPath (str, optional): iconPath value.
        """
        ...


    @property
    def name(self) -> str:
        """
        Item name.
        
        Appears in the JumpList. Has to be unique per category. Must not include embedded NULs ('\\0').
        """
        ...


    @property
    def description(self) -> str:
        """
        Item description, appears as tooltip.
        
        Must not include embedded NULs ('\\0').
        """
        ...


    @property
    def arguments(self) -> str:
        """
        Arguments to be passed to LibreOffice.
        
        This can be a file to be loaded, or any command line parameter supported by LibreOffice, and any combination of the two. Add multiple arguments separated by space. Must not include embedded NULs ('\\0').
        """
        ...


    @property
    def iconPath(self) -> str:
        """
        Icon to be displayed along the name.
        
        Must be a local path name like C:\\\\path\\\\to\\\\icon.ico. Icon must be in ICO format.
        """
        ...


