# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.style
import typing
from abc import ABC
if typing.TYPE_CHECKING:
    from ..awt.size import Size as Size_576707ef
    from ..container.x_name_container import XNameContainer as XNameContainer_cb90e47
    from ..graphic.x_graphic import XGraphic as XGraphic_a4da0afc
    from .graphic_location import GraphicLocation as GraphicLocation_e3ef0d30
    from .page_style_layout import PageStyleLayout as PageStyleLayout_e4070d45
    from ..table.border_line import BorderLine as BorderLine_a3f80af6
    from ..table.shadow_format import ShadowFormat as ShadowFormat_bb840bdf
    from ..text.x_text import XText as XText_690408ca
    from ..text.x_text_columns import XTextColumns as XTextColumns_b17f0bab
    from ..util.color import Color as Color_68e908c5

class PageProperties(ABC):
    """
    Service Class

    describes the style of pages.
    
    **since**
    
        LibreOffice 6.1

    See Also:
        `API PageProperties <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1style_1_1PageProperties.html>`_
    """
    @property
    def BackColor(self) -> 'Color_68e908c5':
        """
        contains the background color of the page.
        """
        ...
    @property
    def BackGraphic(self) -> 'XGraphic_a4da0afc':
        """
        contains the graphic of the background.
        
        **since**
        
            LibreOffice 6.1
        """
        ...
    @property
    def BackGraphicFilter(self) -> str:
        """
        contains the filter name of the background graphic.
        """
        ...
    @property
    def BackGraphicLocation(self) -> 'GraphicLocation_e3ef0d30':
        """
        determines the location of the background graphic.
        """
        ...
    @property
    def BackGraphicURL(self) -> str:
        """
        contains the URL of the background graphic.
        
        Note the new behaviour since it this was deprecated: This property can only be set and only external URLs are supported (no more vnd.sun.star.GraphicObject scheme). When an URL is set, then it will load the graphic and set the BackGraphic property.
        """
        ...
    @property
    def BackTransparent(self) -> bool:
        """
        determines if the background color is transparent.
        
        If this property is set to TRUE, PageStyle.BackColor will not be used.
        """
        ...
    @property
    def BackgroundFullSize(self) -> bool:
        """
        does the background cover the full page or only inside the margins?
        
        **since**
        
            LibreOffice 7.2
        """
        ...
    @property
    def BorderDistance(self) -> int:
        """
        determines the distance of all borders of the page.
        """
        ...
    @property
    def BottomBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the bottom border line of the page.
        """
        ...
    @property
    def BottomBorderDistance(self) -> int:
        """
        determines the bottom border distance of the page.
        """
        ...
    @property
    def BottomMargin(self) -> int:
        """
        determines the bottom margin of the page.
        """
        ...
    @property
    def FirstIsShared(self) -> bool:
        """
        determines if the header/footer content on the first page and remaining pages is the same.
        
        **since**
        
            LibreOffice 4.0
        """
        ...
    @property
    def FooterBackColor(self) -> 'Color_68e908c5':
        """
        contains the color of the background of the footer.
        """
        ...
    @property
    def FooterBackGraphic(self) -> 'XGraphic_a4da0afc':
        """
        contains the graphic of the background of the footer.
        
        **since**
        
            LibreOffice 6.1
        """
        ...
    @property
    def FooterBackGraphicFilter(self) -> str:
        """
        contains the filter name of the background graphic in the footer.
        """
        ...
    @property
    def FooterBackGraphicLocation(self) -> 'GraphicLocation_e3ef0d30':
        """
        determines the location of the background graphic in the footer.
        """
        ...
    @property
    def FooterBackGraphicURL(self) -> str:
        """
        contains the URL of the background graphic in the footer.
        
        Note the new behaviour since it this was deprecated: This property can only be set and only external URLs are supported (no more vnd.sun.star.GraphicObject scheme). When an URL is set, then it will load the graphic and set the FooterBackGraphic property.
        """
        ...
    @property
    def FooterBackTransparent(self) -> bool:
        """
        determines if the background of the footer is transparent.
        """
        ...
    @property
    def FooterBodyDistance(self) -> int:
        """
        determines the distance between the footer and the body text area.
        """
        ...
    @property
    def FooterBorderDistance(self) -> int:
        """
        contains the distance of all borders of the footer.
        """
        ...
    @property
    def FooterBottomBorder(self) -> 'BorderLine_a3f80af6':
        """
        contains the style of the bottom border line of the footer.
        """
        ...
    @property
    def FooterBottomBorderDistance(self) -> int:
        """
        contains the bottom border distance of the footer.
        """
        ...
    @property
    def FooterDynamicSpacing(self) -> bool:
        """
        determines whether to use dynamic spacing in footer or not.
        """
        ...
    @property
    def FooterHeight(self) -> int:
        """
        determines the height of the footer.
        """
        ...
    @property
    def FooterIsDynamicHeight(self) -> bool:
        """
        determines if the height of the footer depends on the content.
        """
        ...
    @property
    def FooterIsOn(self) -> bool:
        """
        determines if a footer is used on the page.
        """
        ...
    @property
    def FooterIsShared(self) -> bool:
        """
        determines if the footer content on left and right pages is the same.
        """
        ...
    @property
    def FooterLeftBorder(self) -> 'BorderLine_a3f80af6':
        """
        contains the style of the left border line of the footer.
        """
        ...
    @property
    def FooterLeftBorderDistance(self) -> int:
        """
        contains the left border distance of the footer.
        """
        ...
    @property
    def FooterLeftMargin(self) -> int:
        """
        determines the left margin of the footer.
        """
        ...
    @property
    def FooterRightBorder(self) -> 'BorderLine_a3f80af6':
        """
        contains the style of the right border line of the footer.
        """
        ...
    @property
    def FooterRightBorderDistance(self) -> int:
        """
        contains the right border distance of the footer.
        """
        ...
    @property
    def FooterRightMargin(self) -> int:
        """
        determines the right margin of the footer.
        """
        ...
    @property
    def FooterShadowFormat(self) -> 'ShadowFormat_bb840bdf':
        """
        determines the shadow of the footer.
        """
        ...
    @property
    def FooterText(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the footer.
        """
        ...
    @property
    def FooterTextLeft(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the footer of a left page.
        """
        ...
    @property
    def FooterTextRight(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the footer of a right page.
        """
        ...
    @property
    def FooterTopBorder(self) -> 'BorderLine_a3f80af6':
        """
        contains the style of the top border line of the footer.
        """
        ...
    @property
    def FooterTopBorderDistance(self) -> int:
        """
        contains the top border distance of the footer.
        """
        ...
    @property
    def FootnoteHeight(self) -> int:
        """
        contains the maximum height of the footnote area.
        
        If set to zero then the height of the current page is used as limit.
        """
        ...
    @property
    def FootnoteLineAdjust(self) -> int:
        """
        contains the adjustment of the separator line between the text and the footnote area.
        
        com.sun.star.text.HorizontalAdjusts.
        """
        ...
    @property
    def FootnoteLineColor(self) -> 'Color_68e908c5':
        """
        contains the color of the separator line between the text and the footnote area.
        """
        ...
    @property
    def FootnoteLineDistance(self) -> int:
        """
        contains the distance between the footnote area and the separator line between the text and the footnote area.
        """
        ...
    @property
    def FootnoteLineRelativeWidth(self) -> int:
        """
        contains the relative width of the separator line between the text and the footnote area.
        """
        ...
    @property
    def FootnoteLineStyle(self) -> int:
        """
        contains the style of the separator line between the text and the footnote area.
        """
        ...
    @property
    def FootnoteLineTextDistance(self) -> int:
        """
        contains the distance between the text and the separator line between the text and the footnote area.
        """
        ...
    @property
    def FootnoteLineWeight(self) -> int:
        """
        contains the weight of the separator line between the text and the footnote area.
        """
        ...
    @property
    def GridBaseHeight(self) -> int:
        """
        contains the height of the base text line inside the text grid
        """
        ...
    @property
    def GridColor(self) -> 'Color_68e908c5':
        """
        contains the display color of the text grid
        """
        ...
    @property
    def GridDisplay(self) -> bool:
        """
        determines whether the text grid lines are visible or not
        """
        ...
    @property
    def GridLines(self) -> int:
        """
        contains the number of lines in the text grid
        """
        ...
    @property
    def GridMode(self) -> int:
        """
        contains the mode of the text grid (none, lines, ...), as represented by com.sun.star.text.TextGridMode constants
        """
        ...
    @property
    def GridPrint(self) -> bool:
        """
        determines whether the text grid lines are printed
        """
        ...
    @property
    def GridRubyBelow(self) -> bool:
        """
        determines whether the text grid's ruby line is located below or above the base line
        """
        ...
    @property
    def GridRubyHeight(self) -> int:
        """
        contains the height of the ruby text line inside the text grid
        """
        ...
    @property
    def GutterMargin(self) -> int:
        """
        determines the gutter margin of the page.
        
        **since**
        
            LibreOffice 7.2
        """
        ...
    @property
    def HeaderBackColor(self) -> 'Color_68e908c5':
        """
        contains the color of the background of the header.
        """
        ...
    @property
    def HeaderBackGraphic(self) -> 'XGraphic_a4da0afc':
        """
        contains the graphic of the background of the header.
        
        **since**
        
            LibreOffice 6.1
        """
        ...
    @property
    def HeaderBackGraphicFilter(self) -> str:
        """
        contains the filter name of the background graphic of the header.
        """
        ...
    @property
    def HeaderBackGraphicLocation(self) -> 'GraphicLocation_e3ef0d30':
        """
        determines the location of the background graphic of the header.
        """
        ...
    @property
    def HeaderBackGraphicURL(self) -> str:
        """
        contains the URL of the background graphic of the header.
        
        Note the new behaviour since it this was deprecated: This property can only be set and only external URLs are supported (no more vnd.sun.star.GraphicObject scheme). When an URL is set, then it will load the graphic and set the HeaderBackGraphic property.
        """
        ...
    @property
    def HeaderBackTransparent(self) -> bool:
        """
        determines if the background color of the header is transparent.
        
        If this property is set to TRUE, PageStyle.HeaderBackColor will not be used.
        """
        ...
    @property
    def HeaderBodyDistance(self) -> int:
        """
        determines the distance between the header and the body text area.
        """
        ...
    @property
    def HeaderBorderDistance(self) -> int:
        """
        determines the distance of all borders of the header.
        """
        ...
    @property
    def HeaderBottomBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the bottom border line of the header.
        """
        ...
    @property
    def HeaderBottomBorderDistance(self) -> int:
        """
        determines the bottom border distance of the header.
        """
        ...
    @property
    def HeaderDynamicSpacing(self) -> bool:
        """
        determines whether to use dynamic spacing in header or not.
        """
        ...
    @property
    def HeaderHeight(self) -> int:
        """
        contains the height of the header.
        """
        ...
    @property
    def HeaderIsDynamicHeight(self) -> bool:
        """
        determines if the height of the header depends on the content.
        """
        ...
    @property
    def HeaderIsOn(self) -> bool:
        """
        determines if a header is used on the page.
        """
        ...
    @property
    def HeaderIsShared(self) -> bool:
        """
        determines if the header content on left and right pages is the same.
        """
        ...
    @property
    def HeaderLeftBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the left border line of the header.
        """
        ...
    @property
    def HeaderLeftBorderDistance(self) -> int:
        """
        determines the left border distance of the header.
        """
        ...
    @property
    def HeaderLeftMargin(self) -> int:
        """
        contains the left margin of the header.
        """
        ...
    @property
    def HeaderRightBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the right border line of the header.
        """
        ...
    @property
    def HeaderRightBorderDistance(self) -> int:
        """
        determines the right border distance of the header.
        """
        ...
    @property
    def HeaderRightMargin(self) -> int:
        """
        contains the right margin of the header.
        """
        ...
    @property
    def HeaderShadowFormat(self) -> 'ShadowFormat_bb840bdf':
        """
        determines the shadow of the header.
        """
        ...
    @property
    def HeaderText(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the header.
        """
        ...
    @property
    def HeaderTextLeft(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the header of left pages.
        """
        ...
    @property
    def HeaderTextRight(self) -> 'XText_690408ca':
        """
        contains the interface to the text of the header of right pages.
        """
        ...
    @property
    def HeaderTopBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the top border line of the header.
        """
        ...
    @property
    def HeaderTopBorderDistance(self) -> int:
        """
        determines the top border distance of the header.
        """
        ...
    @property
    def Height(self) -> int:
        """
        contains the height of the page.
        """
        ...
    @property
    def IsLandscape(self) -> bool:
        """
        determines if the page format is landscape.
        """
        ...
    @property
    def LeftBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the left border line of the page.
        """
        ...
    @property
    def LeftBorderDistance(self) -> int:
        """
        determines the left border distance of the page.
        """
        ...
    @property
    def LeftMargin(self) -> int:
        """
        determines the left margin of the page.
        """
        ...
    @property
    def NumberingType(self) -> int:
        """
        determines the default numbering type for this page.
        """
        ...
    @property
    def PageStyleLayout(self) -> 'PageStyleLayout_e4070d45':
        """
        determines the layout of the page.
        """
        ...
    @property
    def PrinterPaperTray(self) -> str:
        """
        contains the name of a paper tray of the selected printer.
        """
        ...
    @property
    def RegisterModeActive(self) -> bool:
        """
        determines if the register mode is active on that page.
        """
        ...
    @property
    def RegisterParagraphStyle(self) -> str:
        """
        contains the name of the paragraph style that is used as reference of the register mode.
        """
        ...
    @property
    def RightBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the right border line of the page.
        """
        ...
    @property
    def RightBorderDistance(self) -> int:
        """
        determines the right border distance of the page.
        """
        ...
    @property
    def RightMargin(self) -> int:
        """
        determines the right margin of the page.
        """
        ...
    @property
    def RtlGutter(self) -> bool:
        """
        specifies that the page gutter shall be placed on the right side of the page.
        
        **since**
        
            LibreOffice 7.2
        """
        ...
    @property
    def ShadowFormat(self) -> 'ShadowFormat_bb840bdf':
        """
        determines the shadow of the page.
        """
        ...
    @property
    def Size(self) -> 'Size_576707ef':
        """
        contains the paper size of the page.
        """
        ...
    @property
    def TextColumns(self) -> 'XTextColumns_b17f0bab':
        """
        contains the column settings of the page.
        """
        ...
    @property
    def TopBorder(self) -> 'BorderLine_a3f80af6':
        """
        determines the style of the top border line of the page.
        """
        ...
    @property
    def TopBorderDistance(self) -> int:
        """
        determines the top border distance of the page.
        """
        ...
    @property
    def TopMargin(self) -> int:
        """
        determines the top margin of the page.
        """
        ...
    @property
    def UserDefinedAttributes(self) -> 'XNameContainer_cb90e47':
        """
        contains user defined attributes.
        
        This com.sun.star.container.XNameContainer supports the service com.sun.star.xml.AttributeContainer.
        """
        ...
    @property
    def Width(self) -> int:
        """
        contains the width of the page.
        """
        ...
    @property
    def WritingMode(self) -> int:
        """
        contains the writing direction, as represented by the com.sun.star.text.WritingMode2 constants
        """
        ...

