# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.script.vba
from typing_extensions import Literal
from abc import ABC

class XVBAMacroResolver(ABC):
    """
    Converts VBA macro names to script URLs and vice versa.

    See Also:
        `API XVBAMacroResolver <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1script_1_1vba_1_1XVBAMacroResolver.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.script.vba.XVBAMacroResolver']

    def resolveScriptURLtoVBAMacro(self, aScriptURL: str) -> str:
        """
        Returns the VBA macro name for a macro with the passed script URL.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    def resolveVBAMacroToScriptURL(self, aVBAMacroName: str) -> str:
        """
        Returns the script URL representing the passed VBA macro name.

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...


