# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.rendering
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing
from .panose import Panose as Panose_a6bc0b2c
from ..util.tri_state import TriState as TriState_85af09f6


class FontInfo(object):
    """
    Struct Class

    This structure provides information about a specific font.
    
    **since**
    
        OOo 2.0

    See Also:
        `API FontInfo <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1rendering_1_1FontInfo.html>`_
    """
    typeName: Literal['com.sun.star.rendering.FontInfo']

    def __init__(self, FontDescription: typing.Optional[Panose_a6bc0b2c] = ..., FamilyName: typing.Optional[str] = ..., StyleName: typing.Optional[str] = ..., UnicodeRanges0: typing.Optional[int] = ..., UnicodeRanges1: typing.Optional[int] = ..., UnicodeRanges2: typing.Optional[int] = ..., UnicodeRanges3: typing.Optional[int] = ..., IsSymbolFont: typing.Optional[TriState_85af09f6] = ..., IsVertical: typing.Optional[TriState_85af09f6] = ...) -> None:
        """
        Constructor

        Arguments:
            FontDescription (Panose, optional): FontDescription value.
            FamilyName (str, optional): FamilyName value.
            StyleName (str, optional): StyleName value.
            UnicodeRanges0 (int, optional): UnicodeRanges0 value.
            UnicodeRanges1 (int, optional): UnicodeRanges1 value.
            UnicodeRanges2 (int, optional): UnicodeRanges2 value.
            UnicodeRanges3 (int, optional): UnicodeRanges3 value.
            IsSymbolFont (TriState, optional): IsSymbolFont value.
            IsVertical (TriState, optional): IsVertical value.
        """
        ...


    @property
    def FontDescription(self) -> Panose_a6bc0b2c:
        """
        The PANOSE font classification.
        
        TODO: Document semantics in Panose.idl
        """
        ...


    @property
    def FamilyName(self) -> str:
        """
        The name of the font family.
        
        The family name is the one normally associated to a font, such as Times New Roman, Thorndale, Andale or Arial.
        
        Note: outlined fonts are now specified with \"outline\" as part of the family name.
        """
        ...


    @property
    def StyleName(self) -> str:
        """
        The name of the specific font style within its family.
        
        For example, oblique, italic, or narrow.
        """
        ...


    @property
    def UnicodeRanges0(self) -> int:
        """
        This value specifies which Unicode ranges are supported by this font.
        
        This is to be interpreted as a split-up 128-bit value, see Adobe's OpenType specification for the specific meaning of each bit. UnicodeRanges0 contains the least significant bits, UnicodeRanges3 the most significant ones.
        
        const int128 UNICODE_RANGE_BASIC_LATIN = 1; const int128 UNICODE_RANGE_LATIN_SUPPLEMENT = 2; const int128 UNICODE_RANGE_LATIN_EXTENDED_A = 4; const int128 UNICODE_RANGE_LATIN_EXTENDED_B = 4; ... const int128 UNICODE_RANGE_MASK_LATIN = 1; const int128 UNICODE_RANGE_MASK_CJK = (31<<48) + (3<<55) + (1<<59); const int128 UNICODE_RANGE_MASK_CTL = (1<<11) + (1<<13) + (0x3FFF<<15) + (0x0FFF<<70);
        """
        ...


    @property
    def UnicodeRanges1(self) -> int:
        ...


    @property
    def UnicodeRanges2(self) -> int:
        ...


    @property
    def UnicodeRanges3(self) -> int:
        ...


    @property
    def IsSymbolFont(self) -> TriState_85af09f6:
        """
        Specifies whether the font is a symbol font.
        
        If yes, text written in this symbol font does not have a specified meaning.
        """
        ...


    @property
    def IsVertical(self) -> TriState_85af09f6:
        """
        Set to true, if the font is usable for vertical text output.
        
        Vertical fonts have subtle differences to horizontal ones, e.g. rotated or differently shaped glyphs, or special rotated versions of normally upright glyphs (e.g. brackets).
        """
        ...


