# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.presentation
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..animations.x_animation_node import XAnimationNode as XAnimationNode_1cf10eb9
    from ..beans.property_value import PropertyValue as PropertyValue_c9610c73
    from ..drawing.x_draw_page import XDrawPage as XDrawPage_b07a0b57
    from ..drawing.x_draw_pages_supplier import XDrawPagesSupplier as XDrawPagesSupplier_29650f1e
    from ..drawing.x_shape import XShape as XShape_8fd00a3d
    from ..lang.x_multi_service_factory import XMultiServiceFactory as XMultiServiceFactory_191e0eb6
    from .x_shape_event_listener import XShapeEventListener as XShapeEventListener_92a311b5
    from .x_slide_show_listener import XSlideShowListener as XSlideShowListener_81671154
    from .x_slide_show_view import XSlideShowView as XSlideShowView_3eb40fa9

class XSlideShow(XInterface_8f010a43):
    """
    Slide show interface to perform slide show presentations.
    
    This interface provides the necessary methods to run and control a slide show from a given set of XDrawPage slides. The slide show can be displayed simultaneously on multiple targets.
    
    Note: To control a running slide show inside a presentation, please use XPresentation2 and XSlideShowController.
    
    **since**
    
        OOo 3.0

    See Also:
        `API XSlideShow <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1presentation_1_1XSlideShow.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.presentation.XSlideShow']

    def addShapeEventListener(self, xListener: 'XShapeEventListener_92a311b5', xShape: 'XShape_8fd00a3d') -> None:
        """
        Add a shape event listener.
        
        This method adds a listener to the slide show, which will get notified when a mouse click is performed on the given shape. This can be used by clients of the slide show to trigger external actions, such as jumps to different slides.
        """
        ...
    def addSlideShowListener(self, xListener: 'XSlideShowListener_81671154') -> None:
        """
        Add a slide show listener.
        
        This method adds a listener to the slide show, which will get notified when a registered shape is clicked upon, or a new slide is about to be displayed. Note that the listeners will not be notified, when the slide change is directly requested by one of the nextSlide(), previousSlide() or displaySlide() methods.
        """
        ...
    def addView(self, xView: 'XSlideShowView_3eb40fa9') -> bool:
        """
        Add a view to the slide show.
        
        This method adds a view to the slide show. After successful completion of this method, the slide show will be visible on the added view, scaled according to the view's output area.
        """
        ...
    def displaySlide(self, xSlide: 'XDrawPage_b07a0b57', xDrawPages: 'XDrawPagesSupplier_29650f1e', AnimationNode: 'XAnimationNode_1cf10eb9', aProperties: 'typing.Tuple[PropertyValue_c9610c73, ...]') -> None:
        """
        Jump to the given slide.
        
        This method ends all effects on the current slide, displays a possible slide transition, followed by the given slide. If the current slide is equal to the requested slide here, this method does nothing (this especially means, that any currently active effects will remain running).
        """
        ...
    def getCurrentSlide(self) -> 'XDrawPage_b07a0b57':
        """
        Query the currently displayed slide.
        """
        ...
    def nextEffect(self) -> bool:
        """
        Trigger the next effect of the slide show.
        
        This method triggers the next effect on the currently displayed slide. If there is currently no slide show running, this method does nothing. If there are no more effects on the current slide, a possible slide transition effect is issued and the next slide is displayed.
        """
        ...
    def pause(self, bPauseShow: bool) -> bool:
        """
        Change the pause state of the slide show.
        
        This method either pauses the slide show (all currently running effects are stopped), or starts a previously stopped show again (all paused effects start again).
        """
        ...
    def previousEffect(self) -> bool:
        """
        Undo the last effect in the main sequence of the slide show.
        
        The current slide is displayed as if the last user-triggered effect has never been triggered. If there is no previous effect on the current slide then slideEnded(true) is called at the registered XSlideShowListener objects, which can then trigger a change to the previous slide. Note that this command is executed asynchronously. Multiple calls to update() may be necessary to complete its execution. If there is currently no slide show running, this method does nothing.
        """
        ...
    def registerUserPaintPolygons(self, xDocFactory: 'XMultiServiceFactory_191e0eb6') -> None:
        """
        Register drawn polygons in presentation mode.
        """
        ...
    def removeShapeEventListener(self, xListener: 'XShapeEventListener_92a311b5', xShape: 'XShape_8fd00a3d') -> None:
        """
        Revoke a previously registered shape event listener.
        """
        ...
    def removeSlideShowListener(self, xListener: 'XSlideShowListener_81671154') -> None:
        """
        Revoke a previously registered slide show listener.
        """
        ...
    def removeView(self, xView: 'XSlideShowView_3eb40fa9') -> bool:
        """
        Remove view from the slide show.
        
        This method removes the given view from the slide show. After successful completion of this method, the slide show will cease to display on this view.
        """
        ...
    def setProperty(self, aShowProperty: 'PropertyValue_c9610c73') -> bool:
        """
        Change a property of the slide show.
        """
        ...
    def setShapeCursor(self, xShape: 'XShape_8fd00a3d', nPointerShape: int) -> None:
        """
        Set a special mouse cursor for a shape.
        
        This method requests the slide show to display a special cursor, whenever the mouse is hovering over the given shape.
        """
        ...
    def startShapeActivity(self, xShape: 'XShape_8fd00a3d') -> bool:
        """
        Start a shape-intrinsic animation or activity.
        
        This method starts an animation or activity intrinsic to the given shape. Shape-intrinsic activities are things like video playback for multimedia shapes, sounds, GIF animations and drawing layer animations (flipping between shapes in a group, or scroll text).
        """
        ...
    def stopShapeActivity(self, xShape: 'XShape_8fd00a3d') -> bool:
        """
        Stop a shape-intrinsic animation or activity.
        
        This method stops an animation or activity intrinsic to the given shape. Shape-intrinsic activities are things like video playback for multimedia shapes, sounds, GIF animations and drawing layer animations (flipping between shapes in a group, or scroll text).
        """
        ...
    def update(self, nNextTimeout: float) -> bool:
        """
        Update the animations.
        
        This method updates all currently active slide animations. The XSlideShow implementations do not render animations automatically, but must be called from their clients. This allows for various update mechanisms to be employed, ranging from a dedicated rendering thread, over timer-based updates, to rendering in an idle function. Either way, the client of this interface decide about the details.

        * ``nNextTimeout`` is an out direction argument.
        """
        ...


