# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.media
from typing_extensions import Literal
import typing
from ..lang.x_event_listener import XEventListener as XEventListener_c7230c4a
if typing.TYPE_CHECKING:
    from ..lang.event_object import EventObject as EventObject_a3d70b03

class XPlayerListener(XEventListener_c7230c4a):
    """
    Interface to be implemented by a Player listener.
    
    The XPlayerListener interface must be implemented by the clients of the Player service which need to be informed about events while the Player service is displayed.
    
    **since**
    
        LibreOffice 7.4

    See Also:
        `API XPlayerListener <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1media_1_1XPlayerListener.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.media.XPlayerListener']

    def preferredPlayerWindowSizeAvailable(self, e: 'EventObject_a3d70b03') -> None:
        """
        A client receives this event when the preferred player size of an XPlayer is available to be queried.
        """
        ...


