# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.linguistic2
from typing_extensions import Literal
from ..uno.x_interface import XInterface as XInterface_8f010a43

class XDictionaryEntry(XInterface_8f010a43):
    """
    This interfaces gives access to a dictionary entry.
    
    A dictionary entry can supply a word and its hyphenation and indicate if it is a negative word. If it is a negative entry it may supply a replacement text to be used instead of the entry word.
    
    Hyphenation positions are represented by an \"=\" in the word. If the \"=\" is the last character of the word this means it should not be hyphenated. If there is no \"=\" charter in the word, hyphenation positions will be determined automatically (i.e., from the hyphenator service alone).
    
    Entries whose words only differ in hyphenation are considered to be equal. Also a \".\" at the end of the word will make no difference.

    See Also:
        `API XDictionaryEntry <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1linguistic2_1_1XDictionaryEntry.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.linguistic2.XDictionaryEntry']

    def getDictionaryWord(self) -> str:
        """
        """
        ...
    def getReplacementText(self) -> str:
        """
        is the suggested replacement text for negative words.
        
        It is undefined if the entry is not negative.
        """
        ...
    def isNegative(self) -> bool:
        """
        """
        ...


