# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing
from ..linguistic2.x_hyphenated_word import XHyphenatedWord as XHyphenatedWord_3a880f73


class LineBreakResults(object):
    """
    Struct Class

    Results of method XBreakIterator.getLineBreak().

    See Also:
        `API LineBreakResults <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1LineBreakResults.html>`_
    """
    typeName: Literal['com.sun.star.i18n.LineBreakResults']

    def __init__(self, breakType: typing.Optional[int] = ..., breakIndex: typing.Optional[int] = ..., rHyphenatedWord: typing.Optional[XHyphenatedWord_3a880f73] = ...) -> None:
        """
        Constructor

        Arguments:
            breakType (int, optional): breakType value.
            breakIndex (int, optional): breakIndex value.
            rHyphenatedWord (XHyphenatedWord, optional): rHyphenatedWord value.
        """
        ...


    @property
    def breakType(self) -> int:
        """
        Type of line break, see BreakType.
        """
        ...


    @property
    def breakIndex(self) -> int:
        """
        Position of the calculated line break.
        """
        ...


    @property
    def rHyphenatedWord(self) -> XHyphenatedWord_3a880f73:
        """
        Return value of the hyphenator.
        """
        ...


