# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.geometry
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing
from .real_point2_d import RealPoint2D as RealPoint2D_d6e70c78


class EllipticalArc(object):
    """
    Struct Class

    This structure specifies an arbitrary elliptical arc.
    
    This structure contains all parameters necessary to specify arbitrary elliptical arcs. The parameters are modeled closely after the SVG specification.
    
    As with the parameters below, there are mostly four different ellipses arcs (two different ellipses, on which four different arcs connect start and end point) which satisfy the given set of constrains. Thus, there are two flags indicating which one of those ellipses should be taken.
    
    **since**
    
        OOo 2.0

    See Also:
        `API EllipticalArc <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1geometry_1_1EllipticalArc.html>`_
    """
    typeName: Literal['com.sun.star.geometry.EllipticalArc']

    def __init__(self, StartPosition: typing.Optional[RealPoint2D_d6e70c78] = ..., EndPosition: typing.Optional[RealPoint2D_d6e70c78] = ..., RadiusX: typing.Optional[float] = ..., RadiusY: typing.Optional[float] = ..., XAxisRotation: typing.Optional[float] = ..., IsLargeArc: typing.Optional[bool] = ..., IsClockwiseSweep: typing.Optional[bool] = ...) -> None:
        """
        Constructor

        Arguments:
            StartPosition (RealPoint2D, optional): StartPosition value.
            EndPosition (RealPoint2D, optional): EndPosition value.
            RadiusX (float, optional): RadiusX value.
            RadiusY (float, optional): RadiusY value.
            XAxisRotation (float, optional): XAxisRotation value.
            IsLargeArc (bool, optional): IsLargeArc value.
            IsClockwiseSweep (bool, optional): IsClockwiseSweep value.
        """
        ...


    @property
    def StartPosition(self) -> RealPoint2D_d6e70c78:
        """
        Start point of the arc.
        """
        ...


    @property
    def EndPosition(self) -> RealPoint2D_d6e70c78:
        """
        End point of the arc.
        """
        ...


    @property
    def RadiusX(self) -> float:
        """
        Main radius in x direction of the ellipse this arc is part of.
        """
        ...


    @property
    def RadiusY(self) -> float:
        """
        Main radius in y direction of the ellipse this arc is part of.
        """
        ...


    @property
    def XAxisRotation(self) -> float:
        """
        Rotation angle of the x axis of the ellipse relative to the x axis of the reference coordinate system.
        """
        ...


    @property
    def IsLargeArc(self) -> bool:
        """
        If TRUE, and there's a choice, take the longer one of two arcs connecting start and end point.
        """
        ...


    @property
    def IsClockwiseSweep(self) -> bool:
        """
        If TRUE, and there's a choice, take the arc that goes clock-wise from start to end point.
        """
        ...


