# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.embed
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..awt.key_event import KeyEvent as KeyEvent_7a78097f
    from ..awt.rectangle import Rectangle as Rectangle_84b109e9
    from ..awt.size import Size as Size_576707ef
    from ..frame.x_dispatch_provider import XDispatchProvider as XDispatchProvider_fc690de6
    from ..frame.x_layout_manager import XLayoutManager as XLayoutManager_d4510ca4

class XInplaceClient(XInterface_8f010a43):
    """
    represents common functionality for inplace clients.

    See Also:
        `API XInplaceClient <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1embed_1_1XInplaceClient.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.embed.XInplaceClient']

    def activatingInplace(self) -> None:
        """
        notifies container through the client that the object is to be inplace activated.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def activatingUI(self) -> None:
        """
        notifies container through the client that the object is to be UI-activated.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def canInplaceActivate(self) -> bool:
        """
        checks if the container can activate the object inplace.
        """
        ...
    def changedPlacement(self, aPosRect: 'Rectangle_84b109e9') -> None:
        """
        notifies the container that the position of the object is changed.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
            com.sun.star.uno.Exception: ``Exception``
        """
        ...
    def deactivatedInplace(self) -> None:
        """
        notifies container through the client that the object is deactivated.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def deactivatedUI(self) -> None:
        """
        notifies container through the client that the object is UI-deactivated.
        
        After this notification the container can restore its own UI and take focus.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def getClipRectangle(self) -> 'Rectangle_84b109e9':
        """
        gets the inplace object clip rectangle.
        
        The rectangle is provided in object's parent window coordinates in pixels. The intersection of position and clip rectangles specifies the visible part of the object.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def getInplaceDispatchProvider(self) -> 'XDispatchProvider_fc690de6':
        """
        allows to retrieve the container's dispatch provider.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def getLayoutManager(self) -> 'XLayoutManager_d4510ca4':
        """
        allows to retrieve the com.sun.star.frame.LayoutManager of the container.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def getPlacement(self) -> 'Rectangle_84b109e9':
        """
        gets the inplace object position rectangle.
        
        The rectangle is provided in object's parent window coordinates in pixels. The intersection of position and clip rectangles specifies the visible part of the object. In case the position window has a size that is bigger than object's size, the object should either scale or deactivate.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def scrollObject(self, aOffset: 'Size_576707ef') -> None:
        """
        scrolls the object.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...
    def translateAccelerators(self, aKeys: 'typing.Tuple[KeyEvent_7a78097f, ...]') -> None:
        """
        provides accelerator table the object wants to use while it is inplace active.

        Raises:
            com.sun.star.embed.WrongStateException: ``WrongStateException``
        """
        ...


